package com.wangxiaolu.promotion.pojo.activity.manage.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class EmployeeActivityPlanRecordDto implements Serializable {
    /**
     * 主键id
     */
    private Long id;

    /**
     * manage_employee_info表id
     */
    private Integer employeeId;

    /**
     * 文件http地址
     */
    private String excelUrl;

    /**
     * 文件ID（云存储中的id）
     */
    private String excelFiledId;

    /**
     * 创建日期YYYY-MM-DD
     */
    private Date createDate;

    /**
     * 活动月份YYYY-MM
     */
    private String activityMonth;

    /**
     * 月结束日期
     */
    private Date monthStartDate;

    /**
     * 月结束日期
     */
    private Date monthEndDate;

    /**
     * 创建时间
     */
    private Date createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}