package com.wangxiaolu.promotion.controller.user.location;

import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.user.TencentLocationQueryService;
import com.wangxiaolu.promotion.utils.TencentMapUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


/**
 * @Author: DouXinYu
 * @Date: 2026-01-12 11:10
 * @Description:
 */

@RestController
@RequestMapping("/user/location/query")
public class TencentLocationController {
    @Autowired
    TencentLocationQueryService tencentLocationQueryService;

    @GetMapping("/reverse")
    public R getDefaultLocation(@RequestParam("lng") double lng, @RequestParam("lat") double lat){
        TencentMapUtil.AddressInfo addressByLngLat = tencentLocationQueryService.getAddressByLngLat(lng, lat);
        return R.success(addressByLngLat);
    }

//    @GetMapping("/list")
//    public R getProvinceDistinctList(){
//       return R.success(tencentLocationQueryService.getAddressList());
//    }
}
