package com.wangxiaolu.promotion.controller.activityplan;

import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanInfoVo;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanInfoQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-09-03 11
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/plan_info/query")
public class ActivityPlanInfoQueryController {

    @Autowired
    ActivityPlanInfoQueryService activityPlanInfoQueryService;

    @PostMapping("/page")
    public R findActivityInfoPage(@RequestBody PageInfo pageInfo){
        activityPlanInfoQueryService.findActivityPlanInfoPage(pageInfo);
        return R.success(pageInfo);
    }

    /**
     * 查询当前城市经理下，是否存在重复的有效店铺名
     * @return 店铺列表
     */
    @PostMapping("/one")
    public R findStore(@RequestBody ActivityPlanInfoVo activityPlanInfoVo){
        return R.success(activityPlanInfoQueryService.findActivityPlanInfoOne(activityPlanInfoVo));
    }
}
