package com.wangxiaolu.promotion.service.wechat;

import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.user.vo.LoginVo;
import com.wangxiaolu.promotion.pojo.user.vo.TemporaryRegisterVo;

import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-04-09 18
 * @describe :微信人员信息查询
 */
public interface WeChatUserQueryService {

    LoginVo loginTemporaryByOpenIdAndPhone(String openId, String phone);

    LoginVo temporaryLoginByPhone(String phone);

    List<Map<String, String>> findStoreList(String planDay,String storeNameKeyword);

    /**
     * 根据临时ID查询手机号
     * @param temporaryId 临时ID
     * @return 手机号
     */
    String findUserPhoneByID(Long temporaryId);

    Map<String,Object> findTemporaryWorkStore(String openId,String date);

    void queryPage(PageInfo pageInfo);
}
