package com.wangxiaolu.promotion.service.activityplanv2.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityWrapper;
import com.wangxiaolu.promotion.domain.activityplanv2.dao.ActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.enums.plan.PlanStatus;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.planv2.dto.ActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.planv2.response.ActivityResponse;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityPlanVo;
import com.wangxiaolu.promotion.service.activityplanv2.PromPlanQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-02-06 16
 * @describe :
 */
@Service
public class PromPlanQueryServiceImpl implements PromPlanQueryService {

    @Autowired
    private ActivityPlanInfoDao activityPlanInfoDao;
    @Autowired
    private TemporaryActivityReportedDao temporaryActivityReportedDao;
    @Autowired
    private TemporaryActivityClockDao temporaryActivityClockDao;

    @Override
    public void queryPage(PageInfo pageInfo) {
        ActivityPlanInfoWrapper wrapper = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), ActivityPlanInfoWrapper.class);
        activityPlanInfoDao.page(pageInfo,wrapper);
    }

    /**
     * 促销员查询
     */
    @Override
    public List<ActivityPlanInfoDto> findClockList(TemporaryActivityPlanVo temporaryActivityPlanVo) {
        ActivityPlanInfoWrapper wrapper = JSONObject.parseObject(JSONObject.toJSONString(temporaryActivityPlanVo), ActivityPlanInfoWrapper.class);
        wrapper.setActivityDate(Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant()));
        wrapper.setPlanStatus(PlanStatus.NOT_EXECUTION);
        wrapper.setLimitNum(50);
        return activityPlanInfoDao.findClockList(wrapper);
    }

    @Override
    public ActivityPlanInfoDto selectById(Long planId) {
        return activityPlanInfoDao.selectById(planId);
    }

    @Override
    public ActivityResponse queryPlanById(Long id) {
        ActivityPlanInfoDto planInfoDto = activityPlanInfoDao.selectById(id);
        TemporaryActivityWrapper taw = new TemporaryActivityWrapper().setPlanId(id);
        List<TemporaryActivityReportedDto> reportedDtos = temporaryActivityReportedDao.findList(taw);

        ActivityResponse response = new ActivityResponse().setPlanInfo(planInfoDto).setReportedDtos(reportedDtos);
        return response;
    }
}
