package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleStoreDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.StoreWrapper;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeClienteleStoreDto;
import com.wangxiaolu.promotion.pojo.user.vo.ClienteleStoreQueryVo;
import com.wangxiaolu.promotion.service.user.QinCeClienteleDataQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-22 17
 * @describe :
 */
@Slf4j
@Service
public class QinCeClienteleDataQueryServiceImpl implements QinCeClienteleDataQueryService {

    @Autowired
    QinCeClienteleStoreDao qinCeClienteleStoreDao;


    @Override
    public List<QinCeClienteleStoreDto> getStoreList(ClienteleStoreQueryVo storeQueryVo) {
        StoreWrapper sw = new StoreWrapper();
        BeanUtils.copyProperties(storeQueryVo,sw);

        return qinCeClienteleStoreDao.getStoreList(sw);
    }
}
