package com.wangxiaolu.promotion.service.wechat.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.LoginVo;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import com.wangxiaolu.promotion.common.util.JwtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-09 18
 * @describe :微信人员信息查询
 */
@Service
public class WeChatUserQueryServiceImpl implements WeChatUserQueryService {

    private static final Logger log = LoggerFactory.getLogger(WeChatUserQueryServiceImpl.class);
    @Autowired
    TemporaryInfoDao temporaryInfoDao;
    @Autowired
    RedisCache redisCache;
    @Autowired
    JwtUtils jwtUtils;

    /**
     * 根据openId、手机号登录
     */
    @Override
    public LoginVo loginTemporaryByOpenIdAndPhone(String openId, String phone) {
        WxTemporaryInfoDto temDto = temporaryInfoDao.selectOneByOpenId(openId);

        if (Objects.isNull(temDto)) {
            throw new DataException(RCode.LOGIN_USER_IS_NULL_ERROR);
        }

        if (!temDto.getPhone().equals(phone)){
            throw new DataException(RCode.LOGIN_PHONE_PARAM_ERROR);
        }

        String temporaryToken = jwtUtils.getTemporaryToken(openId, phone);
        redisCache.addToJsonToMinute(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey() + temporaryToken, temDto, 360);
        LoginVo loginVo = new LoginVo(temDto, temporaryToken);
        return loginVo;
    }

}
