package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleStoreDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.StoreWrapper;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanInfoVo;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeClienteleStoreDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanInfoCoreService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-09-02 18
 * @describe :
 */
@Service
public class ActivityPlanInfoCoreServiceImpl implements ActivityPlanInfoCoreService {

    @Autowired
    EmployeeActivityPlanInfoDao employeeActivityPlanInfoDao;
    @Autowired
    QinCeClienteleStoreDao qinCeClienteleStoreDao;

    @Override
    public void updateActivityInfo(ActivityPlanInfoVo activityPlanInfoVo) {
        ActivityPlanInfoWrapper wrap = new ActivityPlanInfoWrapper();
        BeanUtils.copyProperties(activityPlanInfoVo, wrap);

        employeeActivityPlanInfoDao.update(wrap);
    }

    /**
     * 根据终端编码验证门店准确性
     */
    @Override
    public void save(ActivityPlanInfoVo activityPlanInfoVo) {
        StoreWrapper storeWrap = new StoreWrapper()
                .setStoreCode(activityPlanInfoVo.getQinceStoreCode());
        QinCeClienteleStoreDto qcStore = qinCeClienteleStoreDao.getOneStore(storeWrap);
        if (Objects.isNull(qcStore) || !qcStore.getStoreName().equals(activityPlanInfoVo.getStoreName())) {
            throw new ParamException(RCode.QINCE_STORE_CODE_ERROR);
        }

        EmployeeActivityPlanInfoDto dto = new EmployeeActivityPlanInfoDto();
        BeanUtils.copyProperties(activityPlanInfoVo, dto);
        employeeActivityPlanInfoDao.saveList(Arrays.asList(dto));
    }
}
