package com.wangxiaolu.promotion.domain.activity.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 促销平台管理后台员工信息
 *
 * @TableName manage_employee_info
 */
@TableName(value = "manage_employee_info")
@Data
public class ManageEmployeeInfoDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 勤策的员工唯一标识
     */
    private String qcId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 员工工号
     */
    private String employeeNo;

    /**
     * 密码
     */
    private String passwork;

    /**
     * 部门信息-勤策部门id，关联部门表qc_id字段
     */
    private String deptQcId;

    /**
     * 部门信息-勤策部门名称
     */
    private String deptQcName;

    /**
     * 备注，不过超过100字
     */
//    private String remarks;

    @TableField(exist = false)
    private List<String> privileges;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}