package com.wangxiaolu.promotion.domain.activity.dao.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityClockMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-23 17
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityClockDaoImpl implements TemporaryActivityClockDao {
    @Autowired
    TemporaryActivityClockMapper temporaryActivityClockMapper;

    @Override
    public void save(TemporaryClockDto dto) {
        // 避免重复打卡
        TemporaryClockWrapper tcw = new TemporaryClockWrapper()
                .setTemporaryId(dto.getTemporaryId())
                .setCreateDate(DateUtil.today());
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = buildWrapper(tcw);
        Integer count = temporaryActivityClockMapper.selectCount(qw);
        if (count > 0) {
            return;
        }

        TemporaryActivityClockDO clockDo = new TemporaryActivityClockDO();
        BeanUtils.copyProperties(dto, clockDo);
        clockDo.setCreateDate(DateUtil.today());
        temporaryActivityClockMapper.insert(clockDo);
        dto.setId(clockDo.getId());
    }

    @Override
    public void updateById(TemporaryClockDto dto) {
        TemporaryActivityClockDO clockDo = new TemporaryActivityClockDO();
        BeanUtils.copyProperties(dto, clockDo);
        temporaryActivityClockMapper.updateById(clockDo);
    }

    /**
     * @param tcw 查询条件
     * @return 上述条件只能满足一条记录
     */
    @Override
    public TemporaryClockDto selectOne(TemporaryClockWrapper tcw) {
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = buildWrapper(tcw);
        TemporaryActivityClockDO clockDO = temporaryActivityClockMapper.selectOne(qw);
        return transitionDto(clockDO);
    }

    @Override
    public List<TemporaryClockDto> selectList(TemporaryClockWrapper tcw) {
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = buildWrapper(tcw);
        List<TemporaryActivityClockDO> clockDOS = temporaryActivityClockMapper.selectList(qw);
        return transitionDtos(clockDOS);
    }

    @Override
    public TemporaryClockDto selectById(Long id) {
        TemporaryActivityClockDO clockDO = temporaryActivityClockMapper.selectById(id);
        return transitionDto(clockDO);
    }

    @Override
    public void employeePage(String employeeQcId, PageInfo pageInfo,TemporaryClockWrapper tcw) {
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = buildWrapper(tcw);
        qw.orderByDesc(TemporaryActivityClockDO::getId);
        Page<TemporaryActivityClockDO> page = new Page<>(pageInfo.getPageNum(), pageInfo.getPageSize());
        Page<TemporaryActivityClockDO> doPage = temporaryActivityClockMapper.selectPage(page, qw);
        pageInfo.pageCovert(doPage);
        pageInfo.setRecords(transitionDtos(doPage.getRecords()));
    }

    @Override
    public TemporaryClockDto findLatestClockByTemporaryId(Integer temporaryId) {
        TemporaryActivityClockDO clockDO = temporaryActivityClockMapper.findLatestClockByTemporaryId(temporaryId);
        return transitionDto(clockDO);
    }

    private LambdaQueryWrapper<TemporaryActivityClockDO> buildWrapper(TemporaryClockWrapper tcw) {
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(tcw.getId())) {
            qw.eq(TemporaryActivityClockDO::getId, tcw.getId());
            return qw;
        }

        if (Objects.nonNull(tcw.getTemporaryId())) {
            qw.eq(TemporaryActivityClockDO::getTemporaryId, tcw.getTemporaryId());
        }

        if (StringUtils.isNotBlank(tcw.getCreateDate())) {
            qw.eq(TemporaryActivityClockDO::getCreateDate, tcw.getCreateDate());
        }

        if (!CollectionUtils.isEmpty(tcw.getReportedIds())){
            qw.in(TemporaryActivityClockDO::getReportedId,tcw.getReportedIds());
        }

        if (Objects.nonNull(tcw.getReportedId())) {
            qw.eq(TemporaryActivityClockDO::getReportedId, tcw.getReportedId());
        }

        if (Objects.nonNull(tcw.getClockOutTimeIsNull()) && tcw.getClockOutTimeIsNull()){
            qw.isNull(TemporaryActivityClockDO::getClockOutTime);
        }
        if (Objects.nonNull(tcw.getCreateDateStart()) && Objects.nonNull(tcw.getCreateDateEnd())){
            qw.between(TemporaryActivityClockDO::getCreateDate,tcw.getCreateDateStart(),tcw.getCreateDateEnd());
        }
        if (StringUtils.isNotBlank(tcw.getNameLike())){
            qw.like(TemporaryActivityClockDO::getTemporaryName,tcw.getNameLike());
        }
        if (StringUtils.isNotBlank(tcw.getDeptQcId())){
            qw.eq(TemporaryActivityClockDO::getDeptQcId, tcw.getDeptQcId());
        }
        if (StringUtils.isNotBlank(tcw.getChargerQcId())){
            qw.eq(TemporaryActivityClockDO::getChargerQcId, tcw.getChargerQcId());
        }

        qw.eq(TemporaryActivityClockDO::getIsDelete, StatusType.VALID.getType());
        return qw;
    }


    /**
     * DO to DTO (单个对象)
     *
     * @param temDos DO对象List
     * @return DTO对象
     */
    private List<TemporaryClockDto> transitionDtos(List<TemporaryActivityClockDO> temDos) {
        if (CollectionUtils.isEmpty(temDos)) {
            return new ArrayList<>();
        }

        List<TemporaryClockDto> dtos = new ArrayList<>(temDos.size() * 2);
        for (TemporaryActivityClockDO temDo : temDos) {
            dtos.add(transitionDto(temDo));
        }
        return dtos;
    }

    private TemporaryClockDto transitionDto(TemporaryActivityClockDO clockDO) {
        TemporaryClockDto dto = null;
        if (Objects.isNull(clockDO)) {
            return dto;
        }
        dto = new TemporaryClockDto();
        BeanUtils.copyProperties(clockDO, dto);
        return dto;
    }
}
