package com.wangxiaolu.promotion.controller.user.employee;

import com.wangxiaolu.promotion.pojo.activity.manage.vo.ManageEmployeeVo;
import com.wangxiaolu.promotion.pojo.user.dto.ManageEmployeeInfoDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.user.ManageEmployeeQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-05-28 19
 * @describe : 王小卤员工登录接口
 */
@RestController
@RequestMapping("/user/employee/query")
public class ManageEmployeeQueryController {

    @Autowired
    ManageEmployeeQueryService manageEmployeeQueryService;

    @PostMapping("/one")
    public R findOne(@RequestBody ManageEmployeeVo manageEmployeeVo){
        ManageEmployeeInfoDto one = manageEmployeeQueryService.findOne(manageEmployeeVo);
        return R.success(one);
    }

    @PostMapping("/list")
    public R findList(@RequestBody ManageEmployeeVo manageEmployeeVo){
        List<ManageEmployeeInfoDto> dtos = manageEmployeeQueryService.findList(manageEmployeeVo);
        return R.success(dtos);
    }

}
