package com.wangxiaolu.promotion.pojo.activity.temporary.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-17 19
 * @describe : 促销员今日活动上报VO
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class TemporaryActivityDataVo {
    /**
     * 促销员活动上报id
     * 关联ID：temporary_activity_reported表id
     */
    private Long activityReportedId;
    /**
     * 促销员id
     * temporaryInfo表id
     */
    private  Long temporaryId;

    /**
     * 促销员姓名
     * temporaryInfo表name
     */
    private String temporaryName;


    /**
     * 活动店铺Id
     */
//    private Long storeId;

    /**
     * 推广试吃照片
     */
    private List<String> tgscPhotoUrls;
    private List<String> tgscChangePhotoUrls;

    /**
     * 推广互动照片
     */
    private List<String> tghdPhotoUrls;
    private List<String> tghdChangePhotoUrls;

    /**
     * 推广成交照片
     */
    private List<String> tgcjPhotoUrls;
    private List<String> tgcjChangePhotoUrls;

    /**
     * POS机页面凭证
     * POS_SELL_VOUCHER
     * psv
     */
    private List<String> psvPhotoUrls;
    private List<String> psvChangePhotoUrls;
    // 促销员联系电话
    private String temporaryPhone;
    // 执行方式
    private String executeModePlan;
    // 配发试吃品是否有黑鸭口味
    private String hasBlackDuckFlavor;
    // 配发黑鸭试吃品（根）
    private Integer blackDuckTastingNum;
    // 配发卤香试吃品（根）
    private Integer braisedTastingNum;
    // 配发赠品个数
    private Integer giftNum;
    // 推广活动销额（元）
    private BigDecimal promotionSales;
    // 黑鸭销售（元）
    private BigDecimal blackDuckSales;
    // 礼盒销售（元）
    private BigDecimal giftBoxSales;

}
