package com.wangxiaolu.promotion.controller.user.tem;

import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.utils.TencentUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-03-07 13
 * @describe :
 */
@RestController
@RequestMapping("/wechat/miniapp/")
public class MiappInfoController {

    @Autowired
    private TencentUtils tencentUtils;

    /**
     * 获取小程序信息
     * @return
     */
    @GetMapping("/wxtoken")
    public R getCX() {
        return R.success(tencentUtils.getMiniappToken());
    }

    @GetMapping("/phone")
    public R getPhone(String accessToken,String code){
        return R.success(tencentUtils.getUserPhoneByAccessToken(accessToken,code));
    }

    @GetMapping("/openid")
    public R getOpenid(String jsCode){
        return R.success(tencentUtils.getOpenid(jsCode));
    }
}
