package com.wangxiaolu.promotion.service.wechat.impl;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.constant.TokenConstants;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.common.util.JwtTokenUtils;
import com.wangxiaolu.promotion.common.util.JwtUtils;
import com.wangxiaolu.promotion.domain.activityplanv2.dao.ActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.activityplanv2.mapper.entity.ActivityPlanInfoDo;
import com.wangxiaolu.promotion.domain.inspection.wrapper.InspectionInfoWrapper;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.TemporaryWrapper;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.LoginVo;
import com.wangxiaolu.promotion.pojo.user.vo.TemporaryRegisterVo;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.stylesheets.LinkStyle;

import java.util.*;

/**
 * @author : liqiulin
 * @date : 2024-04-09 18
 * @describe :微信人员信息查询
 */
@Service
public class WeChatUserQueryServiceImpl implements WeChatUserQueryService {

    @Autowired
    TemporaryInfoDao temporaryInfoDao;
    @Autowired
    RedisCache redisCache;
    @Autowired
    JwtUtils jwtUtils;
    @Autowired
    private ActivityPlanInfoDao activityPlanInfoDao;

    /**
     * 根据openId、手机号登录
     */
    @Override
    public LoginVo loginTemporaryByOpenIdAndPhone(String openId, String phone) {
        WxTemporaryInfoDto temDto = temporaryInfoDao.selectOneByOpenId(openId);

        if (Objects.isNull(temDto)) {
            throw new DataException(RCode.LOGIN_USER_IS_NULL_ERROR);
        }

        if (!temDto.getPhone().equals(phone)){
            throw new DataException(RCode.LOGIN_PHONE_PARAM_ERROR);
        }


        String token = UUID.fastUUID().toString();
        // Jwt存储信息
        Map<String, Object> claimsMap = new HashMap<String, Object>();
        claimsMap.put(TokenConstants.USER_KEY, token);
        claimsMap.put(TokenConstants.DETAILS_USER_ID, temDto.getId());
        claimsMap.put(TokenConstants.DETAILS_USERNAME, temDto.getName());
        String temporaryToken = JwtTokenUtils.createToken(claimsMap);


//        String temporaryToken = jwtUtils.getTemporaryToken(openId, phone);
        redisCache.addToJsonToMinute(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey() + token, temDto, 1080);
        LoginVo loginVo = new LoginVo(temDto, temporaryToken);
        return loginVo;
    }

    @Override
    public LoginVo temporaryLoginByPhone(String phone) {
        WxTemporaryInfoDto temDto = temporaryInfoDao.selectOneByOpenId(phone);
        if (Objects.isNull(temDto)) {
            throw new DataException(RCode.LOGIN_USER_IS_NULL_ERROR);
        }
        String token = UUID.fastUUID().toString();
        // Jwt存储信息
        Map<String, Object> claimsMap = new HashMap<String, Object>();
        claimsMap.put(TokenConstants.USER_KEY, token);
        claimsMap.put(TokenConstants.DETAILS_USER_ID, temDto.getId());
        claimsMap.put(TokenConstants.DETAILS_USERNAME, temDto.getName());
        String temporaryToken = JwtTokenUtils.createToken(claimsMap);


//        String temporaryToken = jwtUtils.getTemporaryToken(openId, phone);
        redisCache.addToJsonToMinute(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey() + token, temDto, 1080);
        LoginVo loginVo = new LoginVo(temDto, temporaryToken);
        return loginVo;
    }

    @Override
    public List<Map<String, String>> findStoreList(String planDay,String storeNameKeyword) {
        return activityPlanInfoDao.findThisMonthStoreListByLocation(planDay, storeNameKeyword);
    }

    @Override
    public String findUserPhoneByID(Long temporaryId) {
        return temporaryInfoDao.selectOneById(temporaryId).getPhone();
    }

    @Override
    public Map<String,Object> findTemporaryWorkStore(String openId,String date) {
        return temporaryInfoDao.selectStoreAndPlan(openId,date);
    }

    @Override
    public void queryPage(PageInfo pageInfo) {
        TemporaryWrapper wq = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), TemporaryWrapper.class);
        temporaryInfoDao.page(pageInfo,wq);
    }
}
