package com.wangxiaolu.promotion.service.user.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.activity.dao.PromotionStoreDao;
import com.wangxiaolu.promotion.domain.user.dao.*;
import com.wangxiaolu.promotion.service.user.QinCeDataTaskService;
import com.wangxiaolu.promotion.utils.OkHttp;
import com.wangxiaolu.promotion.utils.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author : liqiulin
 * @date : 2024-03-29 17
 * @describe :
 */
@Slf4j
@Service
public class QinCeDataTaskServiceImpl implements QinCeDataTaskService {

    @Autowired
    RedisCache redisCache;
    @Autowired
    QinCeUtils qinCeUtils;
    @Autowired
    QinCeDepartmentDao qinCeDepartmentDao;
    @Autowired
    QinCeEmployeeDao qinCeEmployeeDao;
    @Autowired
    QinCeClienteleStoreDao qinCeClienteleShopDao;
    @Autowired
    QinceProductTypeDao qinceProductTypeDao;
    @Autowired
    QinceProductInfoDao qinceProductInfoDao;
    @Autowired
    PromotionStoreDao promotionStoreDao;
    @Autowired
    QinceDealerDao qinceDealerDao;

    @Override
    public void departmentSyncTask() {
        // 查询组织架构参数、创建url
        Map<String, Object> params = qinCeUtils.queryOrgParam();
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_ORGANIZATION, params);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");

        if (responseDatas.size() <= 0) {
            log.error("勤策-同步组织架构/部门数据，未查询到数据");
            return;
        }
        qinCeDepartmentDao.departmentSyncTask(responseDatas);
    }

    @Override
    public void employeeSyncTask(int offset) {
        // 查询组织架构参数、创建url
        Map<String, Object> params = qinCeUtils.queryEmployeeParam(offset);
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_EMPLOYEE, params);
        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");

        if (responseDatas.size() <= 0) {
            log.error("勤策-同步人员数据，未查询到数据");
            return;
        }
        qinCeEmployeeDao.employeeSyncTask(responseDatas);

    }

    /**
     * 同步[终端数据]
     */
    @Override
    public void shopDetailAllTask() {
        int i = 0;
        boolean nextPage = true;
        while (nextPage) {
            i++;
            nextPage = booleanshopDetailPage(i);
        }
    }

    @Override
    public void productQueryPdTypeAllTask() {
        Map<String, Object> params = qinCeUtils.productQueryPdTypeParam();
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_PRODUCT_PD_TYPE, params);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");
        qinceProductTypeDao.productPdTypeSyncTask(responseDatas);
    }

    @Override
    public void productAllTask() {
        Map<String, Object> params = qinCeUtils.queryProductParam();
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_PRODUCT, params);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");
        qinceProductInfoDao.productSyncTask(responseDatas);
    }

    /**
     * 同步经销商
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void productDealers() {
//        Set<Object> dealerIdsR = redisCache.getHashKeys(RedisKeys.UserKeys.DEALER_HAVE_LIST.getKey());
//        if (CollectionUtils.isEmpty(dealerIdsR)){
//            // 将数据库中的经销商保存到redis中
//            Map<Object, Object> dealers = qinceDealerDao.selectAll();
//            dealerIdsR = dealers.keySet();
//            redisCache.putAllHash(RedisKeys.UserKeys.DEALER_HAVE_LIST.getKey(),dealers);
//        }

        int i = 0;
        boolean nextPage = true;
        while (nextPage) {
            i++;
            nextPage = booleanDealersPage(i);
        }
    }

    @Override
    public void employeeSyncTaskAll() {
        // 查询组织架构参数、创建url
        Map<String, Object> params = qinCeUtils.queryEmployeeAllParam();
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_EMPLOYEE, params);
        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");

        if (responseDatas.size() <= 0) {
            log.error("勤策-同步所有有效人员数据，未查询到数据");
            return;
        }
        qinCeEmployeeDao.employeeSyncTask(responseDatas);
    }

    private boolean booleanDealersPage(Integer pageNum){
        Map<String, Object> params = qinCeUtils.queryDealerParam(pageNum);
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_DEALER, params);

        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");
        if (responseDatas.size() <= 0) {
            return false;
        }

        List<Object> dealerAddJsons = new ArrayList<>(1500);
        Map<Object,Object> dealers = new HashMap<>(1500);

        for (int index = 0; index < responseDatas.size(); index++) {
            JSONObject jsonObject = responseDatas.getJSONObject(index);
            // 判断经销商是否有id，没有id则使用code
            String dealerId = jsonObject.getString("dealer_id");
            if (Objects.isNull(dealerId)){
                dealerId = jsonObject.getString("dealer_code");
                jsonObject.put("dealer_id",dealerId);
            }
            // id、code都为空，跳过
            if (StringUtils.isBlank(dealerId)){
                continue;
            }
            // 001588、001488、001485
            List<String> ypIds = Arrays.asList("001588", "001488", "001485");
            if (ypIds.contains(dealerId)){
                jsonObject.put("dealer_manager_code","");
                jsonObject.put("dealer_manager","");
            }
            dealerAddJsons.add(jsonObject);

            // 如果经销商不是合作中，则不存在到redis中
            String dealerCooperateStatus = jsonObject.getString("dealer_cooperate_status");
            if (Objects.nonNull(dealerCooperateStatus) && "1".equals(dealerCooperateStatus)){
                dealers.put(dealerId,jsonObject.getString("dealer_name"));
            }
        }

        // 未新增数据不保存
        if (CollectionUtils.isEmpty(dealerAddJsons)){
            return true;
        }

        log.info("勤策-经销商更新，第{}页数据「{}」条", pageNum, dealerAddJsons.size());
        qinceDealerDao.saveList(dealerAddJsons);
        redisCache.putAllHash(RedisKeys.UserKeys.DEALER_HAVE_LIST.getKey(),dealers);
        return true;
    }


    private boolean booleanshopDetailPage(Integer pageNum) {
        Map<String, Object> params = qinCeUtils.queryShopParam(pageNum);
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_SHORE, params);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");
        if (responseDatas.size() <= 0) {
            log.info("勤策-同步终端数据，第{}页未查询到数据",pageNum);
            return false;
        }

        log.info("勤策-同步终端数据，，第{}页数据「{}」条", pageNum, responseDatas.size());
        qinCeClienteleShopDao.shopDetailAllTask(responseDatas);
//        promotionStoreDao.qinceShopDetailAllTask(responseDatas);
        return true;
    }
}
