package com.wangxiaolu.promotion.controller.activity.examine;

import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.examine.dto.ActivityExamineDto;
import com.wangxiaolu.promotion.pojo.activity.inspectionInfo.dto.InspectionInfoDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.examine.ExaPlanQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.websocket.server.PathParam;

/**
 * @author : liqiulin
 * @date : 2025-04-02 13
 * @describe :
 */
@RestController
@RequestMapping("/exa/query")
public class ExaPlanQueryController {

    @Autowired
    private ExaPlanQueryService exaPlanQueryService;


    @GetMapping("/{id}")
    public R selectById(@PathVariable @PathParam("id") Long id) {
//        ActivityExamineDto examineDto = exaPlanQueryService.selectById(id);
//        if (examineDto != null) {
//            return R.success(examineDto);
//        }
        InspectionInfoDto inspectionInfoDto =exaPlanQueryService.selectNewByID(id);
        return R.success(inspectionInfoDto);
    }

    @PostMapping("/page")
    public R page(@RequestBody PageInfo pageInfo){
        exaPlanQueryService.pageV2(pageInfo);
        return R.success(pageInfo);
    }
    
}
