package com.wangxiaolu.promotion.domain.examine.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动稽查表
 * @TableName activity_examine
 */
@AllArgsConstructor
@NoArgsConstructor
@TableName(value ="activity_examine")
@Data
public class ActivityExamineDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * promotion_manage_employee表id
     */
    private Integer employeeId;

    /**
     * 姓名
     */
    private String employeeName;

    /**
     * 员工工号
     */
    private String employeeNo;

    /**
     * 计划ID
     */
    private Long planId;

    /**
     * 计划状态：执行/未执行
     */
    private String planStatus;
    /**
     * 所属战区名称
     */
    private String deptQcOrgName;

    /**
     * 负责人姓名
     */
    private String manageName;

    /**
     * 执行城市
     */
    private String city;

    /**
     * 计划日期
     */
    private Date planDate;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 活动模式
     */
    private String pattern;

    /**
     * 创建日期
     */
    private Date createDate;

    /**
     * 门头照
     */
    private String storePicture;

    /**
     * 促销员人数
     */
    private Integer temNum;

    /**
     * 地堆：是/否
     */
    private String storeDd;

    /**
     * 促销员是否在岗：在岗/离岗
     */
    private String temOnWork;

    /**
     * 话述：达标/未达标
     */
    private String temHs;

    /**
     * 当话术未达标时，有一个话术未达标原因的备注输入框
     */
    private String temHsRemark;

    /**
     * 物料：齐全/缺少
     */
    private String temWl;

    /**
     * 试吃品是否齐全：齐全/缺少
     */
    private String temWlScp;

    /**
     * 是否有试吃台：有/无
     */
    private String temWlSct;

    /**
     * 是否有试吃托盘：有/无
     */
    private String temWlSctp;

    /**
     * 着装：达标/未达标
     */
    private String temZz;

    /**
     * 工作取证照片
     */
    private String temWorkPhotos;

    /**
     * 特陈照
     */
    private String storeTcPhoto;

    /**
     * 主货架照
     */
    private String storeZhjPhoto;

    /**
     * POS金额
     */
    private BigDecimal posRmb;

    /**
     * pos照片
     */
    private String posPhotos;

    /**
     * 促销员的工资
     */
    private BigDecimal temSalary;

    /**
     * 
     */
    private Date createTime;

    /**
     * 
     */
    private Date modifyTime;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 修改人
     */
    private String modifyBy;

    /**
     * 备注
     */
    private String remark;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}