package com.wangxiaolu.promotion.controller.user.tem;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.exception.FlowException;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.utils.TencentUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-03-07 13
 * @describe :
 */
@RestController
@RequestMapping("/wechat/miniapp")
public class MiappInfoController {

    @Autowired
    private TencentUtils tencentUtils;
    @Autowired
    private RedisCache redisCache;

    /**
     * 获取小程序信息 access_token
     */
//    @GetMapping("/wxtoken")
//    public R getCX() {
//        return R.success(tencentUtils.getMiniappToken());
//    }
    @GetMapping("/phone")
    public R getPhone(String openId, String code) {
        // 检测当前openId获取phone的次数
        checkPhone(openId);
        JSONObject tokenJson = tencentUtils.getMiniappToken();
        JSONObject phoneJson = tencentUtils.getUserPhoneByAccessToken(tokenJson.getString("access_token"), code);
        return R.success(phoneJson);
    }

    @GetMapping("/openid")
    public R getOpenid(String jsCode) {
        return R.success(tencentUtils.getOpenid(jsCode));
    }

    /**
     * 快速获取手机号的次数
     * @return count
     */
    @GetMapping("/logincount")
    public R getLoginPhoneCount(String openId){
        String key = RedisKeys.TemporaryKeys.TEMPORARY_LOGIN_OPENID_COUNT.getKey();
        key = key + DateUtil.today() + "_" + openId;
        return R.success(redisCache.get(key));
    }

    private synchronized void checkPhone(String openId) {
        String key = RedisKeys.TemporaryKeys.TEMPORARY_LOGIN_OPENID_COUNT.getKey();
        key = key + DateUtil.today() + "_" + openId;
        String countStr = redisCache.get(key);
        if (Objects.isNull(countStr)) {
            countStr = String.valueOf(1);
            redisCache.addToMinute(key, countStr, 1440);
            return;
        }

        Integer count = Integer.valueOf(countStr);
        count +=1;
        if (count >= 6) {
            throw new FlowException(RCode.LOGIN_PHONE_COUNT_MUCH);
        }

        countStr = String.valueOf(count);
        redisCache.addToMinute(key, countStr, 1440);

    }
}
