package com.wangxiaolu.promotion.utils;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import lombok.AllArgsConstructor;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2024-04-08 11
 * @describe : 微信工具
 */
@AllArgsConstructor
@Component
public class WxMaUtils {

    private final WxMaService wxMaService;

    /**
     * 根据code查询openId
     */
    public String getWxOpenId(String jsCode) {
        WxMaJscode2SessionResult sessionInfo = null;
        try {
            sessionInfo = wxMaService.getUserService().getSessionInfo(jsCode);
            String openid = sessionInfo.getOpenid();
            return openid;
        } catch (WxErrorException e) {
            throw new RuntimeException();
        }
    }


    /**
     * 微信用户信息解密
     * （粗糙信息）
     */
    public String decrUserInfo(String jsCode, String encryptedData, String iv) {
        WxMaJscode2SessionResult sessionInfo = null;
        try {
            sessionInfo = wxMaService.getUserService().getSessionInfo(jsCode);
            String openid = sessionInfo.getOpenid();
            String sessionKey = sessionInfo.getSessionKey();
            WxMaPhoneNumberInfo phoneNoInfo = wxMaService.getUserService().getPhoneNoInfo(sessionKey, encryptedData, iv);
            String phoneNumber = phoneNoInfo.getPhoneNumber();
            WxMaUserInfo userInfo = wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, iv);
        } catch (WxErrorException e) {
            throw new RuntimeException(e);
        }
        return null;
    }


}
