package com.wangxiaolu.promotion.result.advice;

import com.wangxiaolu.promotion.exception.APIException;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @author : liqiulin
 * @date : 2024-03-28 19
 * @describe : 统一异常处理
 */

@RestControllerAdvice
public class ControllerExceptionAdvice {

    @ExceptionHandler({ParamException.class})
    public R ParamExceptionHandler(ParamException e) {
        return new R(e.getCode(), e.getMsg(), e.getMessage());
    }

    @ExceptionHandler({APIException.class})
    public R APIExceptionHandler(APIException e) {
        return new R(e.getCode(), e.getMsg(), e.getMessage());
    }

    @ExceptionHandler({MethodArgumentNotValidException.class})
    public R MethodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        String msg = e.getBindingResult().getFieldError().getDefaultMessage();
        return new R(RCode.PARAM_ERROR.getCode(), msg);
    }

}
