package com.wangxiaolu.promotion.service.activity.temporary.impl;

import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityPlanVo;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityPlanQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-09-09 16
 * @describe :
 */
@Service
public class TemporaryActivityPlanQueryServiceImpl implements TemporaryActivityPlanQueryService {

    @Autowired
    EmployeeActivityPlanInfoDao employeeActivityPlanInfoDao;

    @Override
    public List<EmployeeActivityPlanInfoDto> findClockStoreList(TemporaryActivityPlanVo planVo) {
        ActivityPlanInfoWrapper wrapper = new ActivityPlanInfoWrapper();
        wrapper.setCity(planVo.getCity())
                .setStoreNameLike(planVo.getStoreName())
                .setActivityStatus(StatusType.VALID);

         return employeeActivityPlanInfoDao.findList(wrapper);
    }
}
