package com.wangxiaolu.promotion.service.activityplanv2.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.excel.ReadExcelUtils;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.activity.dao.ManageEmployeeInfoDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.ManageEmployeeWrapper;
import com.wangxiaolu.promotion.domain.activityplanv2.dao.ActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.activityplanv2.dao.ActivityPlanRecordDao;
import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleStoreDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.StoreWrapper;
import com.wangxiaolu.promotion.enums.plan.OperationType;
import com.wangxiaolu.promotion.enums.plan.PlanStatus;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.exception.FlowException;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.pojo.activity.planv2.dto.ActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.planv2.dto.ActivityPlanRecordDto;
import com.wangxiaolu.promotion.pojo.activity.planv2.vo.ActivityPlanOperVo;
import com.wangxiaolu.promotion.pojo.user.dto.ManageEmployeeInfoDto;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeClienteleStoreDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activityplanv2.PromPlanCoreService;
import com.wangxiaolu.promotion.utils.DateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.*;
import java.time.temporal.TemporalAdjusters;
import java.util.*;

/**
 * @author : liqiulin
 * @date : 2025-01-21 13
 * @describe :
 */
@Service
public class PromPlanCoreServiceImpl implements PromPlanCoreService {

    @Autowired
    private QinCeClienteleStoreDao qinCeClienteleStoreDao;
    @Autowired
    private ActivityPlanRecordDao activityPlanRecordDao;
    @Autowired
    private ActivityPlanInfoDao activityPlanInfoDao;
    @Autowired
    private ManageEmployeeInfoDao manageEmployeeInfoDao;
    @Autowired
    private RedisCache redisCache;

    /**
     * 城市经理 - 上传计划
     */
    @Override
    public Map<String, Object> selfPlanUp(ActivityPlanVo planVo, String filePath) throws DataException {
        // 1、解析活动计划文件是否符合规范
        Map<String, Object> map = readSheetByCSJLUp(planVo, filePath);
        if (!map.containsKey("uuid")){
            return map;
        }

        // 2、生成uuid并关联上传记录
        ActivityPlanRecordDto record = new ActivityPlanRecordDto()
                .setEmployeeId(planVo.getEmployeeId())
                .setEmployeeName(planVo.getEmployeeName())
                .setEmployeeNo(planVo.getEmployeeNo())
                .setExcelUrl(planVo.getExcelUrl())
                .setExcelFiledId(planVo.getExcelId());
        map.put("record", record);
        map.put("type", OperationType.UP.getCode());
        // 保存到缓存（uuid）
        redisCache.addToJsonToMinute(RedisKeys.Manage.ACTIVITY_PLAN_UP.getKey()+map.get("uuid").toString(),map,30);
        // 返回结果
        return map;
    }


    /**
     * 城市经理 - 上传计划
     */
    private Map<String, Object> readSheetByCSJLUp(ActivityPlanVo planVo, String filePath) throws DataException {
        ReadExcelUtils readExcelUtils = new ReadExcelUtils(filePath);
        String[] headers = readExcelUtils.readTitle();
        Map<Integer, List<Object>> rows = readExcelUtils.readContent();

        if (headers.length != 12) {
            throw new DataException(RCode.ACTIVITY_PLAN_TEM_ERROR);
        }
        if (CollectionUtil.isEmpty(rows)) {
            throw new DataException(RCode.READ_EXCEL_NULL_ERROR);
        }

        ArrayList<Integer> indexList = new ArrayList<>();
        for (Map.Entry<Integer, List<Object>> row : rows.entrySet()) {
            List<Object> cells = row.getValue();
            // 判断当前行是否有任一数据为空，如果有则报错，不进行解析
            boolean isEmpty = (cells.size() != 12) || cells.stream().anyMatch(cell -> ObjectUtil.isNull(cell) || StringUtils.isBlank(cell.toString()));
            if (isEmpty) {
                indexList.add(row.getKey() + 1);
            }
        }
        if (CollectionUtil.isNotEmpty(indexList)) {
            throw new DataException(RCode.ACTIVITY_PLAN_CELL_NOT_NULL, indexList);
        }

        Map<String, Object> rMap = new HashMap<>();
        rMap.put("uuid", UUID.randomUUID().toString());

        List<ActivityPlanInfoDto> rDtos = new ArrayList<>(rows.size() * 4);
        // 循环每行
        for (Map.Entry<Integer, List<Object>> row : rows.entrySet()) {
            List<ActivityPlanInfoDto> infoDtos = getRowByCSJLUp(planVo, row.getValue(),rMap);
            rDtos.addAll(infoDtos);
        }
        rMap.put("table", rDtos);
        return rMap;
    }



    /**
     * 城市经理 - 上传计划
     * 循环每天
     */
    private List<ActivityPlanInfoDto> getRowByCSJLUp(ActivityPlanVo planVo, List<Object> row,Map<String, Object> rMap) {
        List<ActivityPlanInfoDto> dtos = new ArrayList<>();
        LocalDate now = LocalDate.now();
//        int monthValue = now.getMonthValue();
        int nextMonthValue = now.plusMonths(1).getMonthValue();

        /**
         * 5：多日期
         */
        String days = row.get(5).toString();
        String[] dayArr = days.split("、");
        for (int i = 0; i < dayArr.length; i++) {
            ActivityPlanInfoDto dto = new ActivityPlanInfoDto();
            try {
                String dayStr = dayArr[i];
                int day = Integer.parseInt(dayStr);

                /**
                 * 0：工号
                 */
                Object empNoO = row.get(0);
                if (!planVo.getEmployeeNo().equals(empNoO.toString())) {
                    dto.setErrorMsg("请填写您自己的工号；");
                } else {
                    dto.setEmployeeId(planVo.getEmployeeId());
                    dto.setEmployeeNo(planVo.getEmployeeNo());
                    dto.setEmployeeName(planVo.getEmployeeName());
                    dto.setOrgQcId(planVo.getDeptQcId());
                    dto.setOrgName(planVo.getDeptQcName());
                    dto.setCreateBy(planVo.getEmployeeName());
                }

                /**
                 *  1：门店编码
                 */
                String sc = row.get(1).toString();
                StoreWrapper storeWrap = new StoreWrapper().setStoreCode(sc);
                QinCeClienteleStoreDto storeDto = qinCeClienteleStoreDao.getOneStore(storeWrap);
                if (ObjectUtil.isEmpty(storeDto)) {
                    dto.setErrorMsg("门店编码错误；");
                } else {
                    if (StringUtils.isAnyBlank(storeDto.getLineName(), storeDto.getDealersName(), storeDto.getDealerId())) {
                        dto.setErrorMsg("门店「系统名称」或「经销商」为空，请到勤策中进充；");
                    }
                    dto.setLineName(storeDto.getLineName());
                    dto.setStoreCode(sc);
                    dto.setStoreName(storeDto.getStoreName());
                    dto.setDealerId(storeDto.getDealerId());
                    dto.setDealerName(storeDto.getDealersName());
                    dto.setProvince(storeDto.getStoreMssProvince());
                    dto.setCity(storeDto.getStoreMssCity());
                    dto.setArea(storeDto.getStoreMssArea());
                    dto.setAddr(storeDto.getStoreAddr());
                }

                /**
                 * 3：活动模式
                 */
                String pattern = row.get(3).toString();
                if ("单点CP,常规MINI秀,校园活动".contains(pattern)) {
                    dto.setPattern(pattern);
                } else {
                    dto.setErrorMsg("活动模式分为：单点CP、常规MINI秀、校园活动；");
                }

                /**
                 * 4：月份 新增逻辑只支持次月计划；
                 * 6：促销员上班时间 当月份错误则促销员上下班、午休下上班不进行计算
                 * 7：促销员下班时间
                 * 年份：当月份为1时，判定为跨年
                 */
                int monthInt = Integer.parseInt(row.get(4).toString());
                int year = DateUtil.thisYear();
                Month month = Month.of(monthInt);
                if (month.equals(Month.JANUARY)) {
                    year += 1;
                }
                LocalDate planDate = LocalDate.of(year, month, day);
//                if (monthInt != nextMonthValue && monthInt != monthValue) {
//                    dto.setErrorMsg("月份只能是当月或次月；");
                if (monthInt != nextMonthValue) {
                    dto.setErrorMsg("月份只能是次月；");
                } else if (planDate.isBefore(LocalDate.now())) {
                    dto.setErrorMsg("日期不能是以前；");
                } else {
                    // 上、下班时间
                    dto.setYear(year).setMonth(planDate.getMonthValue()).setDate(DateUtils.parseDateBylocalDate(planDate));
                    LocalTime inLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(6).toString());
                    LocalTime outLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(7).toString());
                    if (ObjectUtils.anyNull(inLocalTime, outLocalTime)) {
                        dto.setErrorMsg("上下班时间必填；");
                    }
                    if (ObjectUtils.allNotNull(inLocalTime, outLocalTime) && inLocalTime.isAfter(outLocalTime)) {
                        dto.setErrorMsg("下班时间需晚于上班时间；");
                    } else {
                        dto.setClockInTime(LocalDateTime.of(planDate, inLocalTime));
                        dto.setClockOutTime(LocalDateTime.of(planDate, outLocalTime));

                        // 午休时间：上班时间<午休下班时间<午休上班时间<下班时间
                        LocalTime noonOutLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(8).toString());
                        LocalTime noonInLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(9).toString());
                        if (LocalTime.MIDNIGHT.equals(noonOutLocalTime) && LocalTime.MIDNIGHT.equals(noonInLocalTime)) {
                            dto.setNoonClockOutTime(null);
                            dto.setNoonClockInTime(null);
                        } else if (inLocalTime.isBefore(noonOutLocalTime) && noonOutLocalTime.isBefore(noonInLocalTime) && noonInLocalTime.isBefore(outLocalTime)) {
                            dto.setNoonClockOutTime(LocalDateTime.of(planDate, noonOutLocalTime));
                            dto.setNoonClockInTime(LocalDateTime.of(planDate, noonInLocalTime));
                        } else {
                            dto.setErrorMsg("时间错误，正确规则：上班时间<午休下班时间<午休上班时间<下班时间；");
                        }
                    }
                }


                /**
                 * 10：是否有促销台/试吃台
                 */
                String temWlSct = row.get(10).toString();
                if ("有，无".contains(temWlSct)) {
                    dto.setTemWlSct(temWlSct);
                } else {
                    dto.setErrorMsg("是否有促销台请填写：有、无；");
                }


                /**
                 * 11：活动品项
                 */
                String prdClass = row.get(11).toString();
                if ("黑鸭,散称,老品".contains(prdClass)) {
                    dto.setPrdClass(prdClass);
                } else {
                    dto.setErrorMsg("活动品项请填写：黑鸭、散称、老品；");
                }

                // 作废：工资
//                dto.setSalary(new BigDecimal(row.get(8).toString()));
                // 作废：杂费
//                dto.setIncidentals(new BigDecimal(row.get(9).toString()));

                // 判断计划是否已存在
                ActivityPlanInfoDto hasDto = activityPlanInfoDao.selectPlan(dto.getStoreCode(), dto.getDate());
                if (Objects.nonNull(hasDto)) {
                    dto.setErrorMsg("计划已存在，创建人：" + hasDto.getEmployeeName() + "，创建时间：" + DateUtil.formatDate(hasDto.getCreateTime()) + "；");
                }

            } catch (DateTimeException e) {
                dto.setErrorMsg("月份、日期、时间需要调整；");
            }
            if (StringUtils.isNotBlank(dto.getErrorMsg())){
                rMap.remove("uuid");
            }
            dtos.add(dto);
        }

        return dtos;
    }

    /**
     * 职能角色 - 上传计划
     */
    @Override
    public Map<String, Object> authPlanUp(ActivityPlanVo planVo, String filePath) throws DataException {
        // 1、解析活动计划文件是否符合规范
        Map<String, Object> map = readSheetByZNJSUp(planVo, filePath);
        if (!map.containsKey("uuid")){
            return map;
        }

        // 2、生成uuid并关联上传记录
        ActivityPlanRecordDto record = new ActivityPlanRecordDto()
                .setEmployeeId(planVo.getEmployeeId())
                .setEmployeeName(planVo.getEmployeeName())
                .setEmployeeNo(planVo.getEmployeeNo())
                .setExcelUrl(planVo.getExcelUrl())
                .setExcelFiledId(planVo.getExcelId());
        map.put("record", record);
        map.put("type", OperationType.UP.getCode());
        // 保存到缓存（uuid）
        redisCache.addToJsonToMinute(RedisKeys.Manage.ACTIVITY_PLAN_UP.getKey()+map.get("uuid").toString(),map,30);
        // 返回结果
        return map;
    }

    /**
     * 职能角色 - 上传计划
     */
    private Map<String, Object> readSheetByZNJSUp(ActivityPlanVo planVo, String filePath) throws DataException {
        ReadExcelUtils readExcelUtils = new ReadExcelUtils(filePath);
        String[] headers = readExcelUtils.readTitle();
        Map<Integer, List<Object>> rows = readExcelUtils.readContent();

        if (headers.length != 12) {
            throw new DataException(RCode.ACTIVITY_PLAN_TEM_ERROR);
        }
        if (CollectionUtil.isEmpty(rows)) {
            throw new DataException(RCode.READ_EXCEL_NULL_ERROR);
        }

        ArrayList<Integer> indexList = new ArrayList<>();
        for (Map.Entry<Integer, List<Object>> row : rows.entrySet()) {
            List<Object> cells = row.getValue();
            // 判断当前行是否有任一数据为空，如果有则报错，不进行解析
            boolean isEmpty = (cells.size() != 12) || cells.stream().anyMatch(cell -> ObjectUtil.isNull(cell) || StringUtils.isBlank(cell.toString()));
            if (isEmpty) {
                indexList.add(row.getKey() + 1);
            }
        }
        if (CollectionUtil.isNotEmpty(indexList)) {
            throw new DataException(RCode.ACTIVITY_PLAN_CELL_NOT_NULL, indexList);
        }

        Map<String, Object> rMap = new HashMap<>();
        rMap.put("uuid", UUID.randomUUID().toString());

        List<ActivityPlanInfoDto> rDtos = new ArrayList<>(rows.size() * 4);
        for (Map.Entry<Integer, List<Object>> row : rows.entrySet()) {
            List<ActivityPlanInfoDto> infoDtos = getRowByZNJSUp(planVo, row.getValue(),rMap);
            rDtos.addAll(infoDtos);
        }
        rMap.put("table", rDtos);
        return rMap;
    }


    /**
     * 职能角色 - 上传计划
     */
    private List<ActivityPlanInfoDto> getRowByZNJSUp(ActivityPlanVo planVo, List<Object> row,Map<String, Object> rMap) {
        List<ActivityPlanInfoDto> dtos = new ArrayList<>();
        LocalDate now = LocalDate.now();
        int monthValue = now.getMonthValue();
        int nextMonthValue = now.plusMonths(1).getMonthValue();

        /**
         * 5：多日期
         */
        String days = row.get(5).toString();
        String[] dayArr = days.split("、");
        for (int i = 0; i < dayArr.length; i++) {
            ActivityPlanInfoDto dto = new ActivityPlanInfoDto();
            try {
                String dayStr = dayArr[i];
                int day = Integer.parseInt(dayStr);

                /**
                 * 0：工号
                 */
                Object empNoO = row.get(0);
                if (planVo.getEmployeeNo().equals(empNoO.toString())) {
                    dto.setErrorMsg("不能填写自己的工号；");
                } else {
                    // 查询当前工号的人员信息
                    ManageEmployeeInfoDto employeeInfoDto = manageEmployeeInfoDao.selectOne(new ManageEmployeeWrapper().setEmployeeNo(empNoO.toString()));
                    if (Objects.isNull(employeeInfoDto)) {
                        dto.setErrorMsg("员工不存在或被禁用；");
                    } else {
                        dto.setEmployeeId(employeeInfoDto.getId());
                        dto.setEmployeeNo(employeeInfoDto.getEmployeeNo());
                        dto.setEmployeeName(employeeInfoDto.getName());
                        dto.setOrgQcId(employeeInfoDto.getDeptQcId());
                        dto.setOrgName(employeeInfoDto.getDeptQcName());
                        dto.setCreateBy(planVo.getEmployeeName());
                    }
                }

                /**
                 *  1：门店编码
                 */
                String sc = row.get(1).toString();
                StoreWrapper storeWrap = new StoreWrapper().setStoreCode(sc);
                QinCeClienteleStoreDto storeDto = qinCeClienteleStoreDao.getOneStore(storeWrap);
                if (ObjectUtil.isEmpty(storeDto)) {
                    dto.setErrorMsg("门店编码错误；");
                } else {
                    if (StringUtils.isAnyBlank(storeDto.getLineName(), storeDto.getDealersName(), storeDto.getDealerId())) {
                        dto.setErrorMsg("门店「系统名称」或「经销商」为空，请到勤策中进充；");
                    }
                    dto.setLineName(storeDto.getLineName());
                    dto.setStoreCode(sc);
                    dto.setStoreName(storeDto.getStoreName());
                    dto.setDealerId(storeDto.getDealerId());
                    dto.setDealerName(storeDto.getDealersName());
                    dto.setProvince(storeDto.getStoreMssProvince());
                    dto.setCity(storeDto.getStoreMssCity());
                    dto.setArea(storeDto.getStoreMssArea());
                    dto.setAddr(storeDto.getStoreAddr());
                }

                /**
                 * 3：活动模式
                 */
                String pattern = row.get(3).toString();
                if ("单点CP,常规MINI秀,校园活动".contains(pattern)) {
                    dto.setPattern(pattern);
                } else {
                    dto.setErrorMsg("活动模式分为：单点CP、常规MINI秀、校园活动；");
                }

                /**
                 * 4：月份 新增逻辑只支持次月计划；
                 * 6：促销员上班时间 当月份错误，促销员上下班时间也不进行计算
                 * 7：促销员下班时间
                 * 年份：当月份为1时，判定为跨年
                 */
                int year = DateUtil.thisYear();
                int monthInt = Integer.parseInt(row.get(4).toString());
                Month month = Month.of(monthInt);
                if (month.equals(Month.JANUARY)) {
                    year += 1;
                }
                LocalDate planDate = LocalDate.of(year, month, day);
                if (monthInt != nextMonthValue && monthInt != monthValue) {
                    dto.setErrorMsg("月份只能是当月或次月；");
                } else if (planDate.isBefore(LocalDate.now())) {
                    dto.setErrorMsg("日期不能是以前；");
                } else {
                    dto.setYear(year).setMonth(planDate.getMonthValue()).setDate(DateUtils.parseDateBylocalDate(planDate));
                    LocalTime inLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(6).toString());
                    LocalTime outLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(7).toString());
                    if (ObjectUtils.anyNull(inLocalTime, outLocalTime)) {
                        dto.setErrorMsg("上下班时间必填；");
                    }
                    if (ObjectUtils.allNotNull(inLocalTime, outLocalTime) && inLocalTime.isAfter(outLocalTime)) {
                        dto.setErrorMsg("下班时间需晚于上班时间；");
                    } else {
                        dto.setClockInTime(LocalDateTime.of(planDate, inLocalTime));
                        dto.setClockOutTime(LocalDateTime.of(planDate, outLocalTime));

                        // 午休时间：上班时间<午休下班时间<午休上班时间<下班时间
                        LocalTime noonOutLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(8).toString());
                        LocalTime noonInLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(9).toString());

                        if (ObjectUtils.allNotNull(noonOutLocalTime, noonInLocalTime)
                                && inLocalTime.isBefore(noonOutLocalTime)
                                && noonOutLocalTime.isBefore(noonInLocalTime)
                                && noonInLocalTime.isBefore(outLocalTime))
                        {
                            dto.setNoonClockOutTime(LocalDateTime.of(planDate, noonOutLocalTime));
                            dto.setNoonClockInTime(LocalDateTime.of(planDate, noonInLocalTime));
                        }else {
                            dto.setErrorMsg("时间错误，正确规则：上班时间<午休下班时间<午休上班时间<下班时间；");
                        }
                    }
                }

                /**
                 * 10：是否有促销台/试吃台
                 */
                String temWlSct = row.get(10).toString();
                if ("有，无".contains(temWlSct)) {
                    dto.setTemWlSct(temWlSct);
                } else {
                    dto.setErrorMsg("是否有促销台请填写：有、无；");
                }

                /**
                 * 11：活动品项
                 */
                String prdClass = row.get(11).toString();
                if ("黑鸭,散称,老品".contains(prdClass)) {
                    dto.setPrdClass(prdClass);
                } else {
                    dto.setErrorMsg("活动品项请填写：黑鸭、散称、老品；");
                }

                // 8：工资
//                dto.setSalary(new BigDecimal(row.get(8).toString()));
                // 9：杂费
//                dto.setIncidentals(new BigDecimal(row.get(9).toString()));

                // 判断计划是否已存在
                ActivityPlanInfoDto hasDto = activityPlanInfoDao.selectPlan(dto.getStoreCode(), dto.getDate());
                if (Objects.nonNull(hasDto)) {
                    dto.setErrorMsg("计划已存在，创建人：" + hasDto.getEmployeeName() + "，创建时间：" + DateUtil.formatDate(hasDto.getCreateTime()) + "；");
                }

            } catch (DateTimeException e) {
                dto.setErrorMsg("月份、日期、时间需要调整；");
            }
            if (StringUtils.isNotBlank(dto.getErrorMsg())){
                rMap.remove("uuid");
            }
            dtos.add(dto);
        }

        return dtos;
    }

    /**
     * 城市经理 - 修改计划
     */
    @Override
    public Map<String, Object> selfPlanPut(ActivityPlanVo planVo, String filePath) throws DataException {
        // 1、解析活动计划文件是否符合规范
        Map<String, Object> map = readSheetByCSJLPut(planVo,filePath);
        if (!map.containsKey("uuid")){
            return map;
        }

        // 2、生成uuid并关联上传记录
        ActivityPlanRecordDto record = new ActivityPlanRecordDto()
                .setEmployeeId(planVo.getEmployeeId())
                .setEmployeeName(planVo.getEmployeeName())
                .setEmployeeNo(planVo.getEmployeeNo())
                .setExcelUrl(planVo.getExcelUrl())
                .setExcelFiledId(planVo.getExcelId());
        map.put("record", record);
        map.put("type", OperationType.PUT.getCode());
        // 保存到缓存（uuid）
        redisCache.addToJsonToMinute(RedisKeys.Manage.ACTIVITY_PLAN_UP.getKey()+map.get("uuid").toString(),map,30);
        // 返回结果
        return map;
    }

    @Override
    public void putActivityPlan(ActivityPlanOperVo operVo) {
        ActivityPlanInfoDto dto = activityPlanInfoDao.selectById(operVo.getId());
        // 已执行的计划不可修改
        if (PlanStatus.EXECUTION.getCode().equals(dto.getPlanStatus())){
            throw new FlowException(RCode.ACTIVITY_IS_START);
        }
        // 不可修改活动日期 <= 今日 的计划
        if (DateUtils.parseDateBylocalDate(dto.getDate()).isBefore(LocalDate.now())){
            throw new FlowException(RCode.ACTIVITY_PLAN_NOT_DELETE);
        }

        // 判断修改后  月底 >= 活动日期 > 今日
        LocalDate today = LocalDate.now();
        Date planDate = operVo.getDate();
        LocalDate localDatePlan = DateUtils.parseDateBylocalDate(planDate);
        LocalDate lastDayOfMonth = today.with(TemporalAdjusters.lastDayOfMonth());
        if (!localDatePlan.isAfter(today) || localDatePlan.isAfter(lastDayOfMonth)){
            throw new FlowException(RCode.ACTIVITY_PLAN_DATA_ERROR);
        }

        ActivityPlanInfoDto planDto = new ActivityPlanInfoDto();
        // 归属人改变
        if (!operVo.getEmployeeId().equals(dto.getEmployeeId())){
            ManageEmployeeInfoDto employeeInfoDto = manageEmployeeInfoDao.selectById(operVo.getEmployeeId());
            planDto.setEmployeeId(employeeInfoDto.getId())
                    .setEmployeeNo(employeeInfoDto.getEmployeeNo())
                    .setEmployeeName(employeeInfoDto.getName())
                    .setOrgQcId(employeeInfoDto.getDeptQcId())
                    .setOrgName(employeeInfoDto.getDeptQcName());
        }


        StoreWrapper storeWrap = new StoreWrapper().setStoreCode(operVo.getStoreCode());
        QinCeClienteleStoreDto storeDto = qinCeClienteleStoreDao.getOneStore(storeWrap);
        if (!storeDto.getDealerId().equals(dto.getDealerId())){
            throw new FlowException(RCode.QINCE_STORE_DEALER_ERROR);
        }

        planDto.setId(operVo.getId())
                .setLineName(storeDto.getLineName())
                .setStoreCode(storeDto.getStoreCode())
                .setStoreName(storeDto.getStoreName())
                .setDealerId(storeDto.getDealerId())
                .setDealerName(storeDto.getDealersName())
                .setProvince(storeDto.getStoreMssProvince())
                .setCity(storeDto.getStoreMssCity())
                .setArea(storeDto.getStoreMssArea())
                .setAddr(storeDto.getStoreAddr())
                .setDate(planDate)
                .setPattern(operVo.getPattern())
                .setClockInTime(operVo.getClockInTime())
                .setClockOutTime(operVo.getClockOutTime())
                .setModifyBy(operVo.getOperName());
        activityPlanInfoDao.updateById(planDto);
    }

    @Override
    public void saveActivityPlan(ActivityPlanOperVo operVo) {
        ActivityPlanInfoDto planDto = new ActivityPlanInfoDto();
        StoreWrapper storeWrap = new StoreWrapper().setStoreCode(operVo.getStoreCode());
        QinCeClienteleStoreDto storeDto = qinCeClienteleStoreDao.getOneStore(storeWrap);
        ManageEmployeeInfoDto empDto = manageEmployeeInfoDao.selectOne(new ManageEmployeeWrapper().setEmployeeNo(operVo.getEmployeeNo()));
        LocalDate planDate = operVo.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        planDto.setPlanFileId(0L)
                .setEmployeeId(empDto.getId())
                .setEmployeeName(empDto.getName())
                .setEmployeeNo(empDto.getEmployeeNo())
                .setYear(planDate.getYear())
                .setMonth(planDate.getMonthValue())
                .setDate(operVo.getDate())
                .setLineName(storeDto.getLineName())
                .setStoreName(storeDto.getStoreName())
                .setStoreCode(operVo.getStoreCode())
                .setOrgName(empDto.getDeptQcName())
                .setOrgQcId(empDto.getDeptQcId())
                .setPattern(operVo.getPattern())
                .setDealerId(storeDto.getDealerId())
                .setDealerName(storeDto.getDealersName())
                .setProvince(storeDto.getStoreMssProvince())
                .setCity(storeDto.getStoreMssCity())
                .setArea(storeDto.getStoreMssArea())
                .setAddr(storeDto.getStoreAddr())
                .setClockInTime(operVo.getClockInTime())
                .setClockOutTime(operVo.getClockOutTime())
                .setCreateBy(operVo.getOperName());
        activityPlanInfoDao.save(planDto);
    }

    @Override
    public void updatePlanStatus(Long planId, PlanStatus planStatus) {
        activityPlanInfoDao.updatePlanStatus(planId, planStatus);
    }

    @Override
    public void putActivityPlans(ActivityPlanOperVo operVo) {
        ManageEmployeeInfoDto employeeInfoDto = manageEmployeeInfoDao.selectById(operVo.getEmployeeId());
        ActivityPlanInfoDto planDto = new ActivityPlanInfoDto();
        planDto.setEmployeeId(employeeInfoDto.getId())
               .setEmployeeName(employeeInfoDto.getName())
               .setEmployeeNo(employeeInfoDto.getEmployeeNo())
               .setOrgName(employeeInfoDto.getDeptQcName())
               .setOrgQcId(employeeInfoDto.getDeptQcId())
                .setModifyBy(operVo.getOperName());
        activityPlanInfoDao.updateByIds(operVo.getPlanIds(),planDto);
    }

    /**
     * 城市经理 - 修改计划
     */
    private Map<String, Object> readSheetByCSJLPut(ActivityPlanVo planVo,String filePath) throws DataException {
        ReadExcelUtils readExcelUtils = new ReadExcelUtils(filePath);
        String[] headers = readExcelUtils.readTitle();
        Map<Integer, List<Object>> rows = readExcelUtils.readContent();

        if (headers.length != 12) {
            throw new DataException(RCode.ACTIVITY_PLAN_TEM_ERROR);
        }
        if (CollectionUtil.isEmpty(rows)) {
            throw new DataException(RCode.READ_EXCEL_NULL_ERROR);
        }

        ArrayList<Integer> indexList = new ArrayList<>();
        for (Map.Entry<Integer, List<Object>> row : rows.entrySet()) {
            List<Object> cells = row.getValue();
            // 判断当前行是否有任一数据为空，如果有则报错，不进行解析
            boolean isEmpty = (cells.size() != 12) || cells.stream().anyMatch(cell -> ObjectUtil.isNull(cell) || StringUtils.isBlank(cell.toString()));
            if (isEmpty) {
                indexList.add(row.getKey() + 1);
            }
        }
        if (CollectionUtil.isNotEmpty(indexList)) {
            throw new DataException(RCode.ACTIVITY_PLAN_CELL_NOT_NULL, indexList);
        }

        Map<String, Object> rMap = new HashMap<>();
        rMap.put("uuid", UUID.randomUUID().toString());

        List<ActivityPlanInfoDto> rDtos = new ArrayList<>(rows.size() * 4);
        for (Map.Entry<Integer, List<Object>> row : rows.entrySet()) {
            List<ActivityPlanInfoDto> infoDtos = getRowByCSJLPut(planVo,row.getValue(),rMap);
            rDtos.addAll(infoDtos);
        }
        rMap.put("table", rDtos);
        return rMap;
    }

    /**
     * 城市经理 - 修改计划
     */
    private List<ActivityPlanInfoDto> getRowByCSJLPut(ActivityPlanVo planVo,List<Object> row, Map<String, Object> rMap) {
        List<ActivityPlanInfoDto> dtos = new ArrayList<>();

        /**
         * 5：多日期
         */
        String days = row.get(5).toString();
        String[] dayArr = days.split("、");
        for (int i = 0; i < dayArr.length; i++) {
            ActivityPlanInfoDto dto = new ActivityPlanInfoDto();
            try {
                String dayStr = dayArr[i];
                int day = Integer.parseInt(dayStr);
                int monthInt = Integer.parseInt(row.get(4).toString());
                int year = DateUtil.thisYear();
                Month month = Month.of(monthInt);
                if (month.equals(Month.JANUARY)) {
                    year += 1;
                }
                LocalDate planDate = LocalDate.of(year, month, day);
                dto.setYear(year).setMonth(planDate.getMonthValue()).setDate(DateUtils.parseDateBylocalDate(planDate));


                /**
                 *  1：门店编码
                 */
                String sc = row.get(1).toString();
                dto.setStoreCode(sc);
                StoreWrapper storeWrap = new StoreWrapper().setStoreCode(sc);
                QinCeClienteleStoreDto storeDto = qinCeClienteleStoreDao.getOneStore(storeWrap);
                if (ObjectUtil.isEmpty(storeDto)) {
                    dto.setErrorMsg("门店编码错误；");
                } else {
                    if (StringUtils.isAnyBlank(storeDto.getLineName(), storeDto.getDealersName(), storeDto.getDealerId())) {
                        dto.setErrorMsg("门店「系统名称」或「经销商」为空，请到勤策中进充；");
                    }
                    dto.setStoreCode(sc);
                    dto.setStoreName(storeDto.getStoreName());
                    dto.setLineName(storeDto.getLineName());
                    dto.setDealerId(storeDto.getDealerId());
                    dto.setDealerName(storeDto.getDealersName());
                    dto.setProvince(storeDto.getStoreMssProvince());
                    dto.setCity(storeDto.getStoreMssCity());
                    dto.setArea(storeDto.getStoreMssArea());
                    dto.setAddr(storeDto.getStoreAddr());
                    dto.setModifyBy(planVo.getEmployeeName());
                }

                // 判断计划是否已存在，不存在的计划直接跳过
                ActivityPlanInfoDto hasDto = activityPlanInfoDao.selectPlan(dto.getStoreCode(), dto.getDate());
                if (Objects.isNull(hasDto)) {
                    dto.setErrorMsg("计划不存在；");
                    if (StringUtils.isNotBlank(dto.getErrorMsg())) {
                        rMap.remove("uuid");
                    }
                    dtos.add(dto);
                    continue;
                } else if (PlanStatus.EXECUTION.getCode().equals(hasDto.getPlanStatus())) {
                    dto.setErrorMsg("计划已执行，不可修改；");
                } else if (!hasDto.getEmployeeNo().equals(row.get(0).toString())) {
                    dto.setErrorMsg("计划不属于"+row.get(0)+"，归属人：" + hasDto.getEmployeeName() + ";");
                }
                dto.setEmployeeName(hasDto.getEmployeeName())
                        .setOrgQcId(hasDto.getOrgQcId())
                        .setOrgName(hasDto.getOrgName());

                LocalTime inLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(6).toString());
                LocalTime outLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(7).toString());
                if (ObjectUtils.anyNull(inLocalTime, outLocalTime)) {
                    dto.setErrorMsg("上下班时间必填；");
                }
                if (ObjectUtils.allNotNull(inLocalTime, outLocalTime) && inLocalTime.isAfter(outLocalTime)) {
                    dto.setErrorMsg("下班时间需晚于上班时间；");
                } else {
                    dto.setClockInTime(LocalDateTime.of(planDate, inLocalTime));
                    dto.setClockOutTime(LocalDateTime.of(planDate, outLocalTime));

                    // 午休时间：上班时间<午休下班时间<午休上班时间<下班时间
                    LocalTime noonOutLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(8).toString());
                    LocalTime noonInLocalTime = DateUtils.parseLocalTimeByEmdtime(row.get(9).toString());

                    if (ObjectUtils.allNotNull(noonOutLocalTime, noonInLocalTime)
                            && inLocalTime.isBefore(noonOutLocalTime)
                            && noonOutLocalTime.isBefore(noonInLocalTime)
                            && noonInLocalTime.isBefore(outLocalTime))
                    {
                        dto.setNoonClockOutTime(LocalDateTime.of(planDate, noonOutLocalTime));
                        dto.setNoonClockInTime(LocalDateTime.of(planDate, noonInLocalTime));
                    }else {
                        dto.setErrorMsg("时间错误，正确规则：上班时间<午休下班时间<午休上班时间<下班时间；");
                    }
                }

                // 促销员上班时间顺延1小时内，可修改
                if (LocalDateTime.now().isAfter(hasDto.getClockInTime().plusHours(1))){
                    dto.setErrorMsg("已超促销员上班时间1小时，不可修改；");
                }

                /**
                 * 3：活动模式
                 */
                String pattern = row.get(3).toString();
                if ("单点CP,常规MINI秀,校园活动".contains(pattern)) {
                    dto.setPattern(pattern);
                } else {
                    dto.setErrorMsg("活动模式分为：单点CP、常规MINI秀、校园活动；");
                }

                /**
                 * 10：是否有促销台/试吃台
                 */
                String temWlSct = row.get(10).toString();
                if ("有，无".contains(temWlSct)) {
                    dto.setTemWlSct(temWlSct);
                } else {
                    dto.setErrorMsg("是否有促销台请填写：有、无；");
                }

                /**
                 * 11：活动品项
                 */
                String prdClass = row.get(11).toString();
                if ("黑鸭,散称,老品".contains(prdClass)) {
                    dto.setPrdClass(prdClass);
                } else {
                    dto.setErrorMsg("活动品项请填写：黑鸭、散称、老品；");
                }

                // 8：工资
//                dto.setSalary(new BigDecimal(row.get(8).toString()));
                // 9：杂费
//                dto.setIncidentals(new BigDecimal(row.get(9).toString()));

            } catch (DateTimeException e) {
                dto.setErrorMsg("月份、日期、时间需要调整；");
            }
            if (StringUtils.isNotBlank(dto.getErrorMsg())) {
                rMap.remove("uuid");
            }
            dtos.add(dto);
        }
        return dtos;
    }



    @Transactional(rollbackFor = Exception.class)
    @Override
    public synchronized void selfPlanAf(String planUuid) {
        String key = RedisKeys.Manage.ACTIVITY_PLAN_UP.getKey() + planUuid;
        JSONObject mapJson = redisCache.getToJson(key);
        if (Objects.isNull(mapJson)) {
            throw new DataException(RCode.REDIS_PUSH_DATA_NOT_EXIT);
        }
        redisCache.removeKey(key);

        JSONObject record = mapJson.getJSONObject("record");
        JSONArray table = mapJson.getJSONArray("table");
        String type = mapJson.getString("type");
        if (OperationType.UP.getCode().equals(type)) {
            // 保存上传记录
            Long recordId = activityPlanRecordDao.save(record,OperationType.UP);
            activityPlanInfoDao.saveList(table, recordId);
        } else if (OperationType.PUT.getCode().equals(type)) {
            Long recordId = activityPlanRecordDao.save(record,OperationType.PUT);
            activityPlanInfoDao.updateList(table, recordId);
        }
    }

    @Override
    public void deletePlan(List<Long> planIds,String employeeNo,String operNo) {
        activityPlanInfoDao.deleteByPlanIds(planIds, employeeNo,operNo);
    }
}
