package com.wangxiaolu.promotion.service.activity.examine.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.examine.dao.ActivityExamineDao;
import com.wangxiaolu.promotion.domain.examine.wrapperQo.ExamineWrapper;
import com.wangxiaolu.promotion.domain.inspection.dao.InspectionInfoDao;
import com.wangxiaolu.promotion.domain.inspection.wrapper.InspectionInfoWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.examine.dto.ActivityExamineDto;
import com.wangxiaolu.promotion.pojo.activity.inspectionInfo.dto.InspectionInfoDto;
import com.wangxiaolu.promotion.service.activity.examine.ExaPlanQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-04-02 14
 * @describe :
 */
@Service
public class ExaPlanQueryServiceImpl implements ExaPlanQueryService {

    @Autowired
    private ActivityExamineDao activityExamineDao;

    @Autowired
    private InspectionInfoDao inspectionInfoDao;

    @Override
    public ActivityExamineDto selectById(Long id) {
        return activityExamineDao.selectById(id);
    }

    @Override
    public ActivityExamineDto selectByPlanId(Long planId) {
        return activityExamineDao.selectByPlanId(planId);
    }

    @Override
    public void page(PageInfo pageInfo) {
        ExamineWrapper wq = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), ExamineWrapper.class);
        activityExamineDao.page(pageInfo,wq);
    }

    @Override
    public InspectionInfoDto selectNewByID(Long id) {
        return  inspectionInfoDao.selectById( id);
    }

    @Override
    public void pageV2(PageInfo pageInfo) {
        InspectionInfoWrapper wq = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), InspectionInfoWrapper.class);
        inspectionInfoDao.page(pageInfo,wq);
    }
}
