package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.alibaba.fastjson.JSONArray;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.manage.dao.TemporaryActivityTypeDao;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.TemporaryActivityTypeDto;
import com.wangxiaolu.promotion.service.activity.manage.ActivityTypeQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-09-10 13
 * @describe :
 */
@Service
public class ActivityTypeQueryServiceImpl implements ActivityTypeQueryService {
    @Autowired
    TemporaryActivityTypeDao temporaryActivityTypeDao;
    @Autowired
    private RedisCache redisCache;

    @Override
    public void patternToRedis() {
        String key = RedisKeys.TemporaryKeys.TENOIRART_ACTIVITY_PATTERN.getKey();
        String keyDo = RedisKeys.TemporaryKeys.TENOIRART_ACTIVITY_PATTERN_DO.getKey();

        List<TemporaryActivityTypeDto> typeDtos = temporaryActivityTypeDao.selectPatternMap();

        Map<Object, Object> map = new HashMap<>();
        typeDtos.forEach(typeDto -> {
            map.put(String.valueOf(typeDto.getActivityPatternId()),typeDto.getActivityPattern());
        });

        redisCache.removeKeys(Arrays.asList(keyDo,key));
        redisCache.putAllHash(key,map);
        redisCache.addToJson(keyDo,typeDtos);
    }

    @Override
    public JSONArray getActivityPattern() {
        String keyDo = RedisKeys.TemporaryKeys.TENOIRART_ACTIVITY_PATTERN_DO.getKey();
        return redisCache.getToJsonArray(keyDo);
    }
}
