package com.wangxiaolu.promotion.controller.activity.temporary;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.exception.FlowException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.PromotionStoreDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.temporary.PromotionStoreCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-18 13
 * @describe : 店铺操作
 */
@Slf4j
@RestController
@RequestMapping("/activity/promotion/store/core")
public class PromotionStoreCoreController {

    @Autowired
    PromotionStoreCoreService promotionStoreCoreService;
    @Autowired
    RedisCache redisCache;

//    @PostMapping("/save")
//    public R saveStore(@RequestHeader("Authorization") String authorization, @RequestBody PromotionStoreDto promotionStoreDto) {
//        promotionStoreDto.verify();
//        // 是否重复提交
//        repetitiveSaveStore(authorization);
//
//        // 在缓存中查询
//        JSONObject userJson = redisCache.getToJson(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey() + authorization);
//
//        promotionStoreDto.setTemporaryId(userJson.getInteger("id"));
//        promotionStoreDto.setTemporaryName(userJson.getString("name"));
//        promotionStoreDto.setDeptQcId(userJson.getString("deptQcId"));
//        promotionStoreDto.setDeptQcOrgName(userJson.getString("deptQcOrgName"));
//        promotionStoreDto.setChargerQcId(userJson.getString("chargerQcId"));
//        promotionStoreDto.setChargerName(userJson.getString("chargerName"));
//
//        promotionStoreCoreService.saveStore(promotionStoreDto);
//        return R.success();
//    }

    private void repetitiveSaveStore(String authorization) {
        String recordKey = RedisKeys.TemporaryKeys.TEMPORARY_SAVE_STORE_REPETITIVE.getKey() + authorization;
        String record = redisCache.get(recordKey);
        if (Objects.nonNull(record)) {
            throw new FlowException(RCode.PROMOTION_STORE_SAVE_ERROR.getCode(), String.format(RCode.PROMOTION_STORE_SAVE_ERROR.getMsg(), "3"));
        }
        redisCache.addToJsonToMinute(recordKey, authorization, 3);
    }
}
