package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.domain.activity.dao.ManageEmployeeInfoDao;
import com.wangxiaolu.promotion.domain.user.dao.QinCeEmployeeDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.EmployeeWrapper;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.QinCeEmployeeDto;
import com.wangxiaolu.promotion.pojo.user.vo.UserLoginParam;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.user.ManageEmployeeCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-01-13 14
 * @describe :
 */
@Service
public class ManageEmployeeCoreServiceImpl implements ManageEmployeeCoreService {
    @Autowired
    ManageEmployeeInfoDao manageEmployeeInfoDao;
    @Autowired
    QinCeEmployeeDao qinCeEmployeeDao;

    @Override
    public void openAccount(UserLoginParam param) {
        // todo 判断账号在勤策中是否存在
       int count = qinCeEmployeeDao.count(new EmployeeWrapper().setEmpCode(param.getLoginName()));
        if (count <= 0){
            throw new DataException(RCode.QC_USER_IS_NULL_ERROR);
        }
        manageEmployeeInfoDao.openAccount(param.getLoginName(),param.getPrivilegeId());
    }

    /**
     * 修改账号的状态，权限
     */
    @Override
    public void putAccount(UserLoginParam param) {
        manageEmployeeInfoDao.updateAccount(param.getLoginName(), param.getPrivilegeId(), param.getStatus());
    }
}
