package com.wangxiaolu.promotion.controller.yun;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.user.TencentCoreService;
import com.wangxiaolu.promotion.common.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-05-15 15
 * @describe :调用腾讯云短信
 */
@Slf4j
@RestController
@RequestMapping("/user/tencent/sms")
public class UserSendSms {

    @Autowired
    TencentCoreService tencentCoreService;

    /**
     * 腾讯云短信
     */
    @PostMapping("/send/ver_code")
    public R sendSms(@RequestBody Map<String, String> phoneInfo) {
        String phone = phoneInfo.get("phone");
        if (StringUtils.isEmpty(phone) || !DataUtils.phonePattern(phone)) {
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }
        tencentCoreService.sendSmsPhoneVerCode(phone);
        return R.success();
    }


}
