package com.wangxiaolu.promotion.xxljobtask;


import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityTaskClockDO;
import com.wangxiaolu.promotion.enums.activity.ActivityClockTaskStatus;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.enums.activity.TemporaryActivityTaskClockMessageType;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.service.activity.manage.ActivityTypeQueryService;
import com.wangxiaolu.promotion.service.activity.manage.EmployeeCoreTemporaryInfoService;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityTaskClockService;
import com.wangxiaolu.promotion.service.activity.temporary.impl.SubscribeMessageService;
import com.wangxiaolu.promotion.utils.DateUtils;
import com.wangxiaolu.promotion.websocket.TemporaryActivityTaskClockSocketHandler;
import com.wangxiaolu.promotion.websocket.pojo.MessageBean;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.wangxiaolu.promotion.common.constant.WechatConstants.RANDOM_TASK_URL;
import static com.wangxiaolu.promotion.common.constant.WechatConstants.SUBSCRIBE_MESSAGE_TEMPLATE_ID;

/**
 * @author : liqiulin
 * @date : 2024-09-10 12
 * @describe : 活动类型操作
 */
@Component
@Slf4j
public class ActivityStautsHandler {

    @Autowired
    private TemporaryActivityTaskClockService taskClockService;
    @Autowired
    private SubscribeMessageService messageService;
    @Autowired
    private TemporaryActivityTaskClockSocketHandler taskClockSocketHandler;
    @Autowired
    private EmployeeCoreTemporaryInfoService temporaryInfoService;

    @XxlJob("sendSubscribeMessage")
    public void sendSubscribeMessage() {

        DateTime latestDateTime = DateUtil.offsetMinute(new Date(), 15);
        // 1. 查询订单信息和用户订阅记录
        List<TemporaryActivityTaskClockDO> list = taskClockService.list(new LambdaQueryWrapper<TemporaryActivityTaskClockDO>()
                .eq(TemporaryActivityTaskClockDO::getTaskStatus, ActivityClockTaskStatus.TO_BE_START.getType())
                .eq(TemporaryActivityTaskClockDO::getTaskType, ActivityPhotoType.RANDOM_TASK.getType())
//                .le(TemporaryActivityTaskClockDO::getRequiredlockTime, dateTime)
//                .ge(TemporaryActivityTaskClockDO::getRequiredlockTime, new Date())
                );

        for (TemporaryActivityTaskClockDO taskClockDO : list) {
//            if (taskClockDO.getSubscribeStatus() != 1) {
                // 发送websocket 通知用户
                try {
                    MessageBean msgBean = new MessageBean();
                    msgBean.setMsgType(TemporaryActivityTaskClockMessageType.RANDOM_TASK_START.getType());
                    msgBean.setData(taskClockDO);
                    taskClockSocketHandler.sendToUser(taskClockDO.getTemporaryId().toString(), msgBean);
                    log.info("用户{}未订阅活动打卡通知", taskClockDO.getTemporaryName());
                    taskClockDO.setIsSendSubscribe(1);
                    taskClockDO.setSubscribeTime(new Date());
//                    taskClockService.updateById(taskClockDO);
                } catch (IOException e) {
                    // 添加异常处理
                    log.error("发送Websocket订阅通知失败", e);
                    throw new RuntimeException(e);
                }
//                continue;
//            }

            // 2. 构建模板数据（根据小程序订阅模板的字段定义）
            Map<String, String> data = new HashMap<>();
            // 模板中的字段1
            data.put("thing1", "随机任务已开启");
            // 模板中的字段2
            data.put("time2", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            // 模板中的字段3
            data.put("requiredlockTime", DateUtil.format(taskClockDO.getRequiredlockTime(), "yyyy-MM-dd HH:mm"));

            // 3. 发送通知
            // 获取openid
            WxTemporaryInfoDto wxTemporaryInfoDto = temporaryInfoService.selectById(taskClockDO.getTemporaryId());

            String openid = wxTemporaryInfoDto.getOpenId();
            // 3. 发送通知
            String templateId = SUBSCRIBE_MESSAGE_TEMPLATE_ID;
            boolean success = messageService.sendSubscribeMessage(
                    openid,
                    templateId,
                    // 跳转页面
                    RANDOM_TASK_URL,
                    data
            );
            if (success) {
                log.info("促销员{}订阅通知发送成功", taskClockDO.getTemporaryName());
                taskClockDO.setSubscribeTime(new Date());

            }
            // 修改状态 待开始 -> 进行中
            taskClockDO.setTaskStatus(ActivityClockTaskStatus.STARTING.getType());
            taskClockService.updateById(taskClockDO);

        }

    }



}
