package com.wangxiaolu.promotion.pojo.activity.temporary.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.wangxiaolu.promotion.enums.activity.ClockType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-04-23 14
 * @describe :促销员打卡数据DTO
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class TemporaryTaskClockDto {
    /**
     * 主键id
     */
    private Long id;

    private Integer temporaryId;

    /**
     * 活动打卡id
     */
    private Long clockId;

    /**
     * temporary_info表name
     */
    private String temporaryName;

    /**
     * 关联活动上报id
     */
    private Long reportedId;
    /**
     * 任务类型 和图片的工业
     * 10、随机任务 9、pos上传任务
     */
    private Integer taskType;
    /**
     * 任务状态 0 待开始 1、进行中 2、已完成 3、未完成
     */
    private Integer taskStatus;

    /**
     * activity_plan_info表id
     */
    private Long planId;

    /**
     * 打卡时间
     */
    private Date clockTime;

    /**
     * 要求打卡时间
     */
    private Date requiredlockTime;

    /**
     * 创建日期YYYY-MM-DD
     */
    private String createDate;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    // 活动模式Id
    private Integer activityPatternId;

    // 活动模式
    private String activityPattern;

    /**
     * 是否删除
     * 0:否 未删除；1：已删除；
     */
    private Integer isDelete;

    /**
     * 订阅状态 0：未订阅；1：已订阅
     */
    private Integer subscribeStatus;

    // 已发送订阅消息
    private Integer isSendSubscribe;
    /**
     * 订阅消息发送时间
     */
    private Date subscribeTime;
}
