package com.wangxiaolu.promotion.pojo.activity.planv2.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-02-17 13
 * @describe :
 */
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Data
public class ActivityPlanOperVo {
    /**
     * 主键id
     */
    private Long id;

    /**
     * 计划归属人
     */
    private Integer employeeId;
    private String employeeNo;

    /**
     * 操作人
     */
//    private Long operId;

    private String operName;
    private String operNo;

    /**
     * 日期
     */
    private Date date;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 活动模式
     */
    private String pattern;

    /**
     * 上班时间
     */
    private LocalTime inTime;
    private LocalDateTime clockInTime;

    /**
     * 下班时间
     */
    private LocalTime outTime;
    private LocalDateTime clockOutTime;


    /**
     * 午休下班时间
     */
    private LocalTime noonOutTime;
    private LocalDateTime noonClockOutTime;
    /**
     * 午休上班时间
     */
    private LocalTime noonInTime;
    private LocalDateTime noonClockInTime;

    /**
     * 是否有试吃台
     */
    private String temWlSct;
    /**
     * 活动品项：老品/黑鸭/散称
     */
    private String prdClass;
    private List<Long> planIds;
}
