package com.wangxiaolu.promotion.controller.activity.examine;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.pojo.activity.examine.dto.ActivityExamineDto;
import com.wangxiaolu.promotion.pojo.activity.examine.vo.ExaPlanVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.examine.ExaPlanCoreService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-04-02 13
 * @describe :
 */
@RestController
@RequestMapping("/exa/core")
public class ExaPlanCoreController {

    @Autowired
    private ExaPlanCoreService exaPlanCoreService;

    @PostMapping("/save")
    public R saveOne(@RequestBody ExaPlanVo exaPlanVo) {
        ActivityExamineDto examineDto = new ActivityExamineDto();
        BeanUtils.copyProperties(exaPlanVo, examineDto);
        ActivityExamineDto examineN = null;
        if (Objects.isNull(exaPlanVo.getId())) {
            examineDto.setCreateBy(exaPlanVo.getOperName());
            examineN = saveOne(examineDto);
        } else {
            examineDto.setModifyBy(exaPlanVo.getOperName());
            examineN = updateById(examineDto);
        }
        return R.success(examineN);
    }

    private ActivityExamineDto saveOne(ActivityExamineDto examineDto) {
        return exaPlanCoreService.save(examineDto);
    }

    private ActivityExamineDto updateById(ActivityExamineDto examineDto) {
        return exaPlanCoreService.updateById(examineDto);
    }

}





