package com.wangxiaolu.promotion.service.wechat.impl;

import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.WxJsUserInfoVo;
import com.wangxiaolu.promotion.service.wechat.WeChatUserCoreService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-04-08 16
 * @describe :微信用户信息操作
 */
@Service
public class WeChatUserCoreServiceImpl implements WeChatUserCoreService {
    @Autowired
    TemporaryInfoDao temporaryInfoDao;

    /**
     * 保存促销员用户信息
     */
    @Override
    public boolean saveWxUserInfoTemporary(WxJsUserInfoVo wxJsUserInfoVo) {
        WxTemporaryInfoDto temporaryDto = new WxTemporaryInfoDto();
        BeanUtils.copyProperties(wxJsUserInfoVo, temporaryDto);
        int saveId = temporaryInfoDao.saveWxTemporaryInfo(temporaryDto);
        return saveId > 0;
    }
}
