package com.wangxiaolu.promotion.controller.wechat;

import com.wangxiaolu.promotion.pojo.user.vo.WxJsUserInfoVo;
import com.wangxiaolu.promotion.service.wechat.WeChatUserCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-04-03 17
 * @describe : 微信用户信息
 */
@Slf4j
@RestController
@RequestMapping("/user/wechat/core")
public class WeChatUserCoreController {

    @Autowired
    WeChatUserCoreService weChatUserCoreService;

    /**
     * 促销员注册信息
     */
    @PostMapping("/temporary/enroll")
    public boolean enrollUserInfo(@RequestBody @Validated WxJsUserInfoVo wxJsUserInfoVo) {
        return weChatUserCoreService.saveWxUserInfoTemporary(wxJsUserInfoVo);
    }

}
