package com.wangxiaolu.promotion.domain.activityplanv2.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 活动计划店铺excel导入记录
 * @TableName activity_plan_record
 */
@TableName(value ="activity_plan_record")
@Data
public class ActivityPlanRecordDo implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * promotion_manage_employee表id
     */
    private Integer employeeId;

    /**
     * 姓名
     */
    private String employeeName;

    /**
     * 员工工号
     */
    private String employeeNo;

    /**
     * 文件http地址
     */
    private String excelUrl;

    /**
     * 文件ID（云存储中的id）
     */
    private String excelFiledId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 1:有效；0：删除；
     */
    private Integer isDelete;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}