package com.wangxiaolu.promotion.controller.activityplanv2;

import com.wangxiaolu.promotion.common.excel.FileUtils;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activityplanv2.PromPlanCoreService;
import com.wangxiaolu.promotion.service.user.ManageEmployeeQueryService;
import io.jsonwebtoken.lang.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-01-07 13
 * @describe :
 */
@RestController
@RequestMapping("/plan/v2/core")
public class PromPlanCoreController {

    @Autowired
    private PromPlanCoreService promPlanCoreService;
    @Autowired
    private ManageEmployeeQueryService manageEmployeeQueryService;


    /**
     * 城市经理 - 上传计划
     * 当月只能上传次月的新增（当月需要新增需要交由职能角色上传）
     */
    @PostMapping("/self/upload")
    public R selfPlan(@RequestBody ActivityPlanVo activityPlanVo) {
        // 判断当前账号是否是城市经理
        boolean isSelf = manageEmployeeQueryService.isOneSelf(activityPlanVo.getEmployeeId());
        if (!isSelf) {
            throw new DataException(RCode.EMP_PRIVILEGE_ERROR);
        }

        try {
            String[] urlArr = activityPlanVo.getExcelUrl().split("weda-uploader/");
            String fileId = urlArr[urlArr.length - 1];
            if (fileId.length() > 53) {
                throw new DataException(RCode.ACTIVITY_PLAN_FILENAME_LONG);
            }

            String filePath = "/home/" + fileId;
            FileUtils.downloadExcel(activityPlanVo.getExcelUrl(), filePath);
// todo           String filePath = "/Users/a02200059/Desktop/测试新增v3 2.xlsx";
            activityPlanVo.setExcelId(fileId);
            Map<String, Object> map = promPlanCoreService.selfPlanUp(activityPlanVo, filePath);
            return R.success(map);
        } catch (DataException e) {
            return new R(e.getCode(), e.getMsg(), null);
        } catch (Exception e) {
            return R.fail();
        }
    }

    @GetMapping("/self/upload/{uuid}")
    public R selfPlanAf(@PathVariable("uuid") String planUuid){
        promPlanCoreService.selfPlanAf(planUuid);
        return R.success();
    }

    /**
     * 职能角色 - 上传计划
     */
    @GetMapping("/auth/upload")
    public void authPlan(@RequestBody ActivityPlanVo activityPlanVo) {
        // 判断当前账号是否是城市经理
//        boolean isSelf = manageEmployeeQueryService.isOneSelf(activityPlanVo.getEmployeeId());
//        if (!isSelf) {
//            throw new DataException(RCode.EMP_PRIVILEGE_ERROR);
//        }
//
//        try {
//            String[] urlArr = activityPlanVo.getExcelUrl().split("weda-uploader/");
//            String fileId = urlArr[urlArr.length - 1];
//            if (fileId.length() > 53) {
//                throw new DataException(RCode.ACTIVITY_PLAN_FILENAME_LONG);
//            }
//
//            String filePath = "/home/" + fileId;
//            FileUtils.downloadExcel(activityPlanVo.getExcelUrl(), filePath);
//            String filePath = "/Users/a02200059/Desktop/测试新增v3 2.xlsx";
//            activityPlanVo.setExcelId(fileId);
//            Map<String, Object> map = promPlanCoreService.selfPlanUp(activityPlanVo, filePath);
//            return R.success(map);
//        } catch (DataException e) {
//            return new R(e.getCode(), e.getMsg(), null);
        }

    /**
     * 删除计划 计划日期大于今日可直接删除，如果计划日期是今日则必需是10点之前，包含过去日期不可删除
     */
    @DeleteMapping("/delete")
    public R deletePlan(@RequestBody ActivityPlanVo activityPlanVo){
        if (Collections.isEmpty(activityPlanVo.getPlanIds())){
            throw new ParamException(RCode.NEED_PARAM_ERROR);
        }
        promPlanCoreService.deletePlan(activityPlanVo.getPlanIds());
        return R.success();
    }



}
