package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.domain.user.dao.QinceDealerDao;
import com.wangxiaolu.promotion.domain.user.mapper.QinceDealerMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.QinceDealerDO;
import com.wangxiaolu.promotion.domain.user.wrapperQo.DealerWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeDealerDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author : liqiulin
 * @date : 2024-08-27 19
 * @describe :
 */
@Slf4j
@Service
public class QinceDealerDaoImpl implements QinceDealerDao {

    @Autowired
    QinceDealerMapper qinceDealerMapper;

    @Override
    public void saveList(List<Object> dealerJsons) {
        // 目前没有查重逻辑，只在前边判断逻辑中判断是否新增
        qinceDealerMapper.saveList(dealerJsons);
        log.info("勤策同步经销商，新增数量：{}",dealerJsons.size());
    }

    @Override
    public void page(PageInfo pageInfo,DealerWrapper dealerWrapper) {
        LambdaQueryWrapper<QinceDealerDO> qw = builderWrapper(dealerWrapper);
        Page<QinceDealerDO> page = new Page<>(pageInfo.getPageNum(), pageInfo.getPageSize());
        Page<QinceDealerDO> doPage = qinceDealerMapper.selectPage(page, qw);
        pageInfo.pageCovert(page);
        pageInfo.setRecords(doPage.getRecords());
    }
    
    private LambdaQueryWrapper<QinceDealerDO> builderWrapper(DealerWrapper dealerWrapper){
        LambdaQueryWrapper<QinceDealerDO> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(dealerWrapper.getDealerId())){
            qw.eq(QinceDealerDO::getDealerId, dealerWrapper.getDealerId());
        }
        if (StringUtils.isNotBlank(dealerWrapper.getDealerName())){
            qw.like(QinceDealerDO::getDealerName, dealerWrapper.getDealerName());
        }

        qw.select(QinceDealerDO::getDealerId, QinceDealerDO::getDealerName);
        return qw;
    }

    @Override
    public Map<Object, Object> selectAll() {
        List<QinceDealerDO> qinceDealerDOS = qinceDealerMapper.selectList(null);
        Map<Object,Object> maps = new HashMap<>(qinceDealerDOS.size()*2);

        qinceDealerDOS.forEach(qinceDealerDO -> {
            maps.put(qinceDealerDO.getDealerId(),qinceDealerDO.getDealerName());
        });
        return maps;
    }

    @Override
    public List<QinCeDealerDto> selectList(DealerWrapper dw) {
        LambdaQueryWrapper<QinceDealerDO> qw = builderWrapper(dw);
        qw.last("limit 20");
        List<QinceDealerDO> qinceDealerDOS = qinceDealerMapper.selectList(qw);
        return transitionDtos(qinceDealerDOS);
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param dos DO对象List
     * @return DTO对象
     */
    private List<QinCeDealerDto> transitionDtos(List<QinceDealerDO> dos) {
        if (CollectionUtils.isEmpty(dos)) {
            return new ArrayList<>();
        }

        List<QinCeDealerDto> dtos = new ArrayList<>(dos.size() * 2);
        for (QinceDealerDO infoDo : dos) {
            dtos.add(transitionDto(infoDo));
        }
        return dtos;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param infoDo DO对象
     * @return DTO对象
     */
    private QinCeDealerDto transitionDto(QinceDealerDO infoDo) {
        QinCeDealerDto temporaryDto = null;
        if (!Objects.isNull(infoDo)) {
            temporaryDto = new QinCeDealerDto();
            BeanUtils.copyProperties(infoDo, temporaryDto);
        }
        return temporaryDto;
    }

}
