package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.TemporaryWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.service.activity.manage.EmployeeQueryTemporaryInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-13 10
 * @describe : 员工查询促销员信息
 */
@Service
public class EmployeeQueryTemporaryInfoServiceImpl implements EmployeeQueryTemporaryInfoService {

    @Autowired
    TemporaryInfoDao temporaryInfoDao;

    @Override
    public void findTemporaryInfoPage(String employeeQcId, PageInfo pageInfo) {
        TemporaryWrapper tw = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), TemporaryWrapper.class);
        tw = Objects.isNull(tw) ? new TemporaryWrapper() : tw;
        temporaryInfoDao.findPage(tw, pageInfo);
    }
}
