package com.wangxiaolu.promotion.pojo.activity.manage.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动计划店铺excel导入记录
 */
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Data
public class ActivityPlanRecordDto implements Serializable {
    /**
     * 主键id
     */
    private Long id;

    /**
     * promotion_manage_employee表id
     */
    private Integer employeeId;

    /**
     * 姓名
     */
    private String employeeName;

    /**
     * 员工工号
     */
    private String employeeNo;

    /**
     * 文件http地址
     */
    private String excelUrl;

    /**
     * 文件ID（云存储中的id）
     */
    private String excelFiledId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 1:有效；0：删除；
     */
    private Integer isDelete;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}