package com.wangxiaolu.promotion.pojo.activity.manage.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;

/**
 * 活动计划
 */
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Data
public class ActivityPlanInfoDto implements Serializable {
    /**
     * 主键id
     */
    private Long id;

    /**
     * 活动计划表上传记录id
     */
    private Long planFileId;

    /**
     * promotion_manage_employee表id
     */
    private Integer employeeId;

    /**
     * 姓名
     */
    private String employeeName;

    /**
     * 员工工号
     */
    private String employeeNo;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 月份
     */
    private Integer month;

    /**
     * 日期
     */
    private Date date;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 战区-勤策ID
     */
    private String orgQcId;

    /**
     * 战区名称
     */
    private String orgName;

    /**
     * 活动模式id
     */
    private Integer patternId;

    /**
     * 活动模式
     */
    private String pattern;

    /**
     * 经销商编码
     */
    private String dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 是否双T门店
     */
    private String bothT;

    /**
     * 门店所属行政区域-省份名称，如：北京市、江苏省
     */
    private String province;

    /**
     * 门店所属行政区域-城市名称，如：南京市
     */
    private String city;

    /**
     * 门店所属行政区域-区县名称，如：鼓楼区
     */
    private String area;

    /**
     * 门店所在地址
     */
    private String addr;

    /**
     * 上班时间
     */
    private LocalDateTime clockInTime;

    /**
     * 下班时间
     */
    private LocalDateTime clockOutTime;

    /**
     * 工资
     */
    private BigDecimal salary;

    /**
     * 杂费
     */
    private BigDecimal incidentals;

    /**
     * 是否执行：1:执行；0：未执行；
     */
    private Integer planStatus;

    private Integer index;

    private Date createTime;

    /**
     * 当前行错误，不可保存
     * 错误信息
     */
    private String errorMsg;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    public void setErrorMsg(String errorMsg) {
        if (Objects.isNull(this.errorMsg)) {
            this.errorMsg = errorMsg;
        } else {
            this.errorMsg += errorMsg;
        }
    }
}