package com.wangxiaolu.promotion.service.activity.manage.impl;

import cn.hutool.core.util.ObjectUtil;
import com.wangxiaolu.promotion.common.excel.FileUtils;
import com.wangxiaolu.promotion.common.excel.ReadExcelUtils;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.activity.dao.ManageEmployeeInfoDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.ManageEmployeeWrapper;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanRecordDao;
import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleStoreDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.StoreWrapper;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanRecordDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.pojo.user.dto.ManageEmployeeInfoDto;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeClienteleStoreDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanRecordCoreService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-08-21 13
 * @describe :
 */
@Service
public class ActivityPlanRecordCoreServiceImpl implements ActivityPlanRecordCoreService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    EmployeeActivityPlanRecordDao employeeActivityPlanRecordDao;
    @Autowired
    EmployeeActivityPlanInfoDao employeeActivityPlanInfoDao;
    @Autowired
    ManageEmployeeInfoDao manageEmployeeInfoDao;
    @Autowired
    QinCeClienteleStoreDao qinCeClienteleStoreDao;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveActivityPlan(EmployeeActivityPlanRecordDto planDto, ActivityPlanVo activityPlanVo) throws Exception {
        // 保存上传记录
        Long planRecordId = employeeActivityPlanRecordDao.save(planDto);
        planDto.setId(planRecordId);
        // 解析excel表是否符合规范、保存
        saveActivityPlanInfo(activityPlanVo, planDto);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteById(Long id) {
        employeeActivityPlanRecordDao.deleteById(id);
        employeeActivityPlanInfoDao.deletebyActivityPlanRecordId(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void transferActivityPlan(ActivityPlanVo activityPlanVo) {
        ManageEmployeeInfoDto oriUser = manageEmployeeInfoDao.selectById(activityPlanVo.getOriginalEmpId());
        ManageEmployeeInfoDto tranUser = manageEmployeeInfoDao.selectById(activityPlanVo.getTransferEmpId());
        if (Objects.isNull(oriUser) || Objects.isNull(tranUser)) {
            throw new DataException(RCode.CHARGER_ID_ERROR);
        }

        employeeActivityPlanRecordDao.transfer(oriUser.getId(), tranUser);
        employeeActivityPlanInfoDao.transfer(oriUser.getId(), tranUser);
    }

    private void saveActivityPlanInfo(ActivityPlanVo activityPlanVo, EmployeeActivityPlanRecordDto planDto) throws Exception {
        // 下载
        String filePath = "/home/" + planDto.getExcelFiledId();
        FileUtils.downloadExcel(activityPlanVo.getExcelUrl(), filePath);

        // 读取
        List<EmployeeActivityPlanInfoDto> planInfoDtos = readSheet0(filePath, activityPlanVo, planDto);
        // 保存
        employeeActivityPlanInfoDao.saveList(planInfoDtos);
    }

//    private void downloadExcel(String urlStr, String filePath) throws Exception {
//        // 保存文件
//        URL url = new URL(urlStr);
//        URLConnection urlConnection = url.openConnection();
//        InputStream inputStream = urlConnection.getInputStream();
//        FileOutputStream fileOutputStream = new FileOutputStream(filePath);
//        // 调大小
//        byte[] buffer = new byte[102400];
//        int bytesRead;
//        while ((bytesRead = inputStream.read(buffer)) != -1) {
//            fileOutputStream.write(buffer, 0, bytesRead);
//        }
//        fileOutputStream.close();
//        inputStream.close();
//    }

    private List<EmployeeActivityPlanInfoDto> readSheet0(String filePath, ActivityPlanVo activityPlanVo, EmployeeActivityPlanRecordDto planDto) throws Exception {
        // 1、解析表格数据
        ReadExcelUtils readExcelUtils = new ReadExcelUtils(filePath);
        Map<Integer, List<Object>> rows = readExcelUtils.readContent();
        String[] headers = readExcelUtils.readTitle();
        if (rows.size() <= 0) {
            throw new DataException(RCode.API_DATA_ERROR);
        }
        // 2、校验表头
        validateHeader(headers);

        // 判断是否是城市经理已经的数据，5列数据是城市经理自己的，6列数据是战区顾问批量上传的
        if (rows.get(1).size() == 6) {
            return saveEmployeeOneselfPlan(rows, activityPlanVo, planDto);
        } else if (rows.get(1).size() == 7) {
            return saveDistrictPlan(rows, activityPlanVo, planDto);
        } else {
            throw new DataException(RCode.API_DATA_ERROR);
        }
    }

    public void validateHeader(String[] templateHeader) {
        StringBuilder msg = new StringBuilder();
        if (templateHeader.length < 5 || templateHeader.length > 7) {
             throw new DataException("模板异常");
        }

        String[] expectedHeaderGh = {"执行城市（二级行政单位市）", "门店负责人-工号", "经销商编码（T100中的编码）", "系统名称", "门店编码（勤策-终端编码）", "门店名称（勤策-终端名称）", "活动模式"};
        String[] expectedHeader = {"执行城市（二级行政单位市）", "经销商编码（T100中的编码）", "系统名称", "门店编码（勤策-终端编码）", "门店名称（勤策-终端名称）", "活动模式"};
        // 包含工号
        boolean containsGh = templateHeader[1].contains("门店负责人-工号");
        if(containsGh){
            for (int i = 0; i < expectedHeaderGh.length; i++) {
                String expectHeaderStr = String.format("第%d列表头是：%s;", i + 1, expectedHeaderGh[i]);
                if (!(i< templateHeader.length && templateHeader[i].contains(expectedHeaderGh[i]) )) {
                    msg.append(expectHeaderStr);
                }
            }
        }else{
            for (int i = 0; i < expectedHeader.length; i++) {
                String expectHeaderStr = String.format("第%d列表头是：%s;", i + 1, expectedHeader[i]);
                if (!(i< templateHeader.length && templateHeader[i].contains(expectedHeader[i]) )) {
                    msg.append(expectHeaderStr);
                }
            }
        }
        if (msg.toString().length() > 0) {
            throw new DataException("模板不正确:"+ msg);
        }
    }

    /**
     * 读取表格并进行数据校验
     * 上传文件人员：城市经理自己
     */
    private List<EmployeeActivityPlanInfoDto> saveEmployeeOneselfPlan(Map<Integer, List<Object>> rows, ActivityPlanVo activityPlanVo, EmployeeActivityPlanRecordDto planDto) throws Exception {
        // 查询当前用户下有效的门店名称列表，用于检查是否存在同名店铺
        Set<String> storeNameDbList = employeeActivityPlanInfoDao.findStoreNameByEmployeeId(activityPlanVo.getEmployeeId());
        Map<Object, Object> dealers = redisCache.getAllHash(RedisKeys.UserKeys.DEALER_HAVE_LIST.getKey());
        Map<Object, Object> patternMap = redisCache.getAllHash(RedisKeys.TemporaryKeys.TENOIRART_ACTIVITY_PATTERN.getKey());
        // 2、校验数据准确性
        verifyRowEmployeeOneselfPlan(rows, dealers, patternMap.values(), storeNameDbList);

        Map<String, Integer> patternInfoMap = new HashMap<>();
        for (Map.Entry<Object, Object> entry : patternMap.entrySet()) {
            patternInfoMap.put(entry.getValue().toString(), Integer.parseInt((String) entry.getKey()));
        }
        /**
         * 3、保存入库
         */
        List<EmployeeActivityPlanInfoDto> planInfoDtos = new ArrayList<>(rows.size() * 2);

        for (Map.Entry<Integer, List<Object>> entry : rows.entrySet()) {
            List<Object> value = entry.getValue();

            EmployeeActivityPlanInfoDto planInfoDto = new EmployeeActivityPlanInfoDto()
                    .setActivityPlanRecordId(planDto.getId())
                    .setExcelFiledId(planDto.getExcelFiledId())
                    .setEmployeeId(activityPlanVo.getEmployeeId())
                    .setEmployeeName(activityPlanVo.getEmployeeName())
                    .setEmployeeNo(activityPlanVo.getEmployeeNo())
                    .setActivityMonth(planDto.getActivityMonth())
                    .setCity((String) value.get(0))
                    .setDealerId((String) value.get(1))
                    .setDealerName((String) dealers.get(value.get(1)))
                    .setLineName((String) value.get(2))
                    .setQinceStoreCode((String) value.get(3))
                    .setStoreName((String) value.get(4))
                    .setActivityPattern((String) value.get(5));

            planInfoDto.setActivityPatternId(patternInfoMap.get(planInfoDto.getActivityPattern()));

            planInfoDtos.add(planInfoDto);
        }
        return planInfoDtos;
    }

    /**
     * 读取表格并进行数据校验
     * 上传文件人员：城市顾问批量上传
     */
    private List<EmployeeActivityPlanInfoDto> saveDistrictPlan(Map<Integer, List<Object>> rows, ActivityPlanVo activityPlanVo, EmployeeActivityPlanRecordDto planDto) throws Exception {

        // 查询当前用户下有效的门店名称列表，用于检查是否存在同名店铺
        Set<String> storeNameDbList = employeeActivityPlanInfoDao.findStoreNameByEmployeeId(activityPlanVo.getEmployeeId());
        Map<Object, Object> dealers = redisCache.getAllHash(RedisKeys.UserKeys.DEALER_HAVE_LIST.getKey());
        Map<Object, Object> patternMap = redisCache.getAllHash(RedisKeys.TemporaryKeys.TENOIRART_ACTIVITY_PATTERN.getKey());
        // 2、校验数据准确性并返回涉及到的城市经理工号
        Set<String> employeeNos = verifyDistrictPlan(rows, dealers, patternMap.values(), storeNameDbList);
        List<ManageEmployeeInfoDto> employeeInfos = manageEmployeeInfoDao.selectList(new ManageEmployeeWrapper().setEmployeeNos(employeeNos));
        Map<String, ManageEmployeeInfoDto> employeeInfoMap = employeeInfos.stream().collect(Collectors.toMap(ManageEmployeeInfoDto::getEmployeeNo, o -> o));

        Map<String, Integer> patternInfoMap = new HashMap<>();
        for (Map.Entry<Object, Object> entry : patternMap.entrySet()) {
            patternInfoMap.put(entry.getValue().toString(), Integer.parseInt((String) entry.getKey()));
        }
        /**
         * 3、保存入库
         */
        List<EmployeeActivityPlanInfoDto> planInfoDtos = new ArrayList<>(rows.size() * 2);

        for (Map.Entry<Integer, List<Object>> entry : rows.entrySet()) {
            List<Object> value = entry.getValue();
            ManageEmployeeInfoDto employeeInfo = employeeInfoMap.get((String) value.get(1));
            if (Objects.isNull(employeeInfo)) {
                throw new DataException("工号错误：" + value.get(1));
            }

            EmployeeActivityPlanInfoDto planInfoDto = new EmployeeActivityPlanInfoDto()
                    .setActivityPlanRecordId(planDto.getId())
                    .setExcelFiledId(planDto.getExcelFiledId())
                    .setEmployeeId(employeeInfo.getId())
                    .setEmployeeName(employeeInfo.getName())
                    .setEmployeeNo(employeeInfo.getEmployeeNo())
                    .setActivityMonth(planDto.getActivityMonth())
                    .setCity((String) value.get(0))
                    .setDealerId((String) value.get(2))
                    .setDealerName((String) dealers.get(value.get(2)))
                    .setLineName((String) value.get(3))
                    .setQinceStoreCode((String) value.get(4))
                    .setStoreName((String) value.get(5))
                    .setActivityPattern((String) value.get(6));

            planInfoDto.setActivityPatternId(patternInfoMap.get(planInfoDto.getActivityPattern()));

            planInfoDtos.add(planInfoDto);
        }
        return planInfoDtos;
    }

    /**
     * 校验数据是否规范
     * 上传文件人员：城市经理自己
     */
    private void verifyRowEmployeeOneselfPlan(Map<Integer, List<Object>> rows, Map<Object, Object> dealers, Collection<Object> patterns, Set<String> storeNameDbSet) throws Exception {

        StringBuilder msg = new StringBuilder();
        List<String> storeList = new ArrayList<>(storeNameDbSet);
        boolean patternY = false;

        for (Map.Entry<Integer, List<Object>> entry : rows.entrySet()) {
            Integer rowNo = entry.getKey() + 1;
            List<Object> value = entry.getValue();

            StringBuilder sb = new StringBuilder();
            String city = (String) value.get(0);
            if (StringUtils.isBlank(city)) {
                sb.append("城市不可为空；");
            } else if (!city.contains("市")) {
                value.set(0, city + "市");
            }

            if (StringUtils.isBlank((String) value.get(2))) {
                sb.append("系统名称不可为空；");
            }

            String dealerId = ((String) value.get(1)).trim();
            if (StringUtils.isBlank(dealerId)) {
                sb.append("经销商编码不可为空；");
                dealerId = "";
            }

            String qinceStoreCode = (String) value.get(3);
            String storeName = (String) value.get(4);

            if (StringUtils.isBlank(storeName) || StringUtils.isBlank(qinceStoreCode)) {
                sb.append("店铺编码/名称不可为空；");
            } else {
                // 验证店铺code是否存在
                StoreWrapper storeWrap = new StoreWrapper().setStoreCode(qinceStoreCode);
                QinCeClienteleStoreDto oneStore = qinCeClienteleStoreDao.getOneStore(storeWrap);
                if (ObjectUtil.isEmpty(oneStore)) {
                    sb.append("勤策店铺编码不正确；");
                } else {
                    if (!storeName.equals(oneStore.getStoreName())) {
                        sb.append("店铺名称不正确；");
                    }
                    if (!dealerId.equals(oneStore.getDealerId())) {
                        sb.append("经销商编码不正确；");
                    }
                }
            }

            String pattern = (String) value.get(5);
            if (StringUtils.isBlank(pattern)) {
                sb.append("活动模式不可为空；");
            } else if (!patterns.contains(pattern)) {
                patternY = true;
            }

            if (sb.length() > 0) {
                msg.append("第").append(rowNo).append("行：").append(sb);
            }

        }

        if (patternY) {
            msg.append("活动模式列仅限：").append(patterns).append("（需区分大小写）");
        }
        if (msg.length() > 0) {
            throw new DataException(msg.toString());
        }

    }

    /**
     * 校验数据是否规范
     * 上传文件人员：城市顾问批量上传
     */
    private Set<String> verifyDistrictPlan(Map<Integer, List<Object>> rows, Map<Object, Object> dealers, Collection<Object> patterns, Set<String> storeNameDbSet) throws Exception {

        Set<String> employeeNos = new HashSet<>(20);
        StringBuilder msg = new StringBuilder();
        List<String> storeList = new ArrayList<>(storeNameDbSet);
        boolean patternY = false;

        for (Map.Entry<Integer, List<Object>> entry : rows.entrySet()) {
            Integer rowNo = entry.getKey() + 1;
            List<Object> value = entry.getValue();

            StringBuilder sb = new StringBuilder();
            String city = (String) value.get(0);
            if (StringUtils.isBlank(city)) {
                sb.append("城市不可为空；");
            } else if (!city.contains("市")) {
                value.set(0, city + "市");
            }

            if (StringUtils.isBlank((String) value.get(1))) {
                sb.append("门店负责人不可为空；");
            } else {
                employeeNos.add((String) value.get(1));
            }

            if (StringUtils.isBlank((String) value.get(3))) {
                sb.append("系统名称不可为空；");
            }

            String dealerId = ((String) value.get(2)).trim();
            if (StringUtils.isBlank(dealerId)) {
                sb.append("经销商编码不可为空；");
                dealerId = "";
            }

            String qinceStoreCode = (String) value.get(4);
            String storeName = (String) value.get(5);

            if (StringUtils.isBlank(storeName) || StringUtils.isBlank(qinceStoreCode)) {
                sb.append("店铺编码/名称不可为空；");
            } else {
                // 验证店铺code是否存在
                StoreWrapper storeWrap = new StoreWrapper().setStoreCode(qinceStoreCode);
                QinCeClienteleStoreDto oneStore = qinCeClienteleStoreDao.getOneStore(storeWrap);
                if (ObjectUtil.isEmpty(oneStore)) {
                    sb.append("勤策店铺编码不正确；");
                } else {
                    if (!storeName.equals(oneStore.getStoreName())) {
                        sb.append("店铺名称不正确；");
                    }
                    if (!dealerId.equals(oneStore.getDealerId())) {
                        sb.append("经销商编码不正确；");
                    }
                }
            }


            String pattern = (String) value.get(6);
            if (StringUtils.isBlank(pattern)) {
                sb.append("活动模式不可为空；");
            } else if (!patterns.contains(pattern)) {
                patternY = true;
            }

            if (sb.length() > 0) {
                msg.append("第").append(rowNo).append("行：").append(sb);
            }
//            entry.setValue(value);
        }


        if (patternY) {
            msg.append("活动模式列仅限：").append(patterns).append("（需区分大小写）");
        }
        if (msg.length() > 0) {
            throw new DataException(msg.toString());
        }

        return employeeNos;
    }


}
