package com.wangxiaolu.promotion.utils;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author : liqiulin
 * @date : 2024-03-29 18
 * @describe : 勤策 api请求配置
 */
@Component
@Slf4j
public class QinCeUtils {

    /**
     * =================== 勤策API - config ===================
     */
    private static final String OPEN_API = "https://openapi.region2.qince.com";
    private static final String OPEN_ID = "8030282350124307682";
    private static final String APP_KEY = "Gx0yQw4UhDtNjESmDl";


    /**
     * =================== 勤策API - path ===================
     */
    // 部门、组织架构
    public static final String QUERY_ORGANIZATION = "/api/organization/v1/queryOrganization/";
    // 员工列表
    public static final String QUERY_EMPLOYEE = "/api/employee/v3/queryEmployee/";

    public String builderUrl(String sidepath, Map<String, Object> params) {
        String msgId = UUID.randomUUID().toString();
        Long currentTimeMillis = System.currentTimeMillis();

        String digest = getDigest(params, currentTimeMillis);
        StringBuilder builder = new StringBuilder().append(OPEN_API).append(sidepath).append(OPEN_ID).append("/").append(currentTimeMillis).append("/").append(digest).append("/").append(msgId);
        return builder.toString();
    }

    /**
     * 查询部门参数
     */
    public Map<String, Object> queryOrgParam() {
        Map<String, Object> params = new HashMap<>();
        params.put("id", "");
        params.put("org_id", "");
        params.put("org_code", "");
        params.put("org_name", "");
        params.put("org_status", "");
        params.put("create_date", "");
        params.put("modify_date", "");
        return params;
    }

    /**
     * 查询人员参数
     */
    public Map<String, Object> queryEmployeeParam(boolean queryId) {
        Map<String, Object> params = new HashMap<>();
        // 根据来源勤策的员工唯一标识精确查询
        if (queryId){
            params.put("id", "");
        }

        // 根据来源第三方系统的员工唯一标识精确查询，id、emp_id如果同时存在优先取id
        params.put("emp_id", "");
        // 根据员工登录帐号精确查询
        params.put("emp_code", "");
        // 根据姓名模糊查询
        params.put("emp_name", "");
        // 根据人员编码精确查询
        params.put("employee_code", "");
        // 根据员工状态查询
        params.put("emp_status", "");
        // 根据创建日期查询用户。格式：yyyy-MM-dd
        params.put("create_date", "");
        // 根据修改日期查询用户。格式：yyyy-MM-dd
        params.put("modify_date", "");
        // 根据手机号查询
        params.put("emp_mobile", "");
        return params;
    }


    private String getDigest(Map<String, Object> params, Long currentTimeMillis) {
        String json = "";
        if (!CollectionUtils.isEmpty(params)) {
            json = JSONObject.toJSONString(params);
        }
        System.out.println(json + "|" + APP_KEY + "|" + currentTimeMillis);
        String digest = DigestUtils.md5Hex(json + "|" + APP_KEY + "|" + currentTimeMillis);
        return digest;
    }

}
