package com.wangxiaolu.promotion.service.user.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.user.dao.QinCeDepartmentDao;
import com.wangxiaolu.promotion.domain.user.dao.QinCeEmployeeDao;
import com.wangxiaolu.promotion.service.user.QinCeDataTaskService;
import com.wangxiaolu.promotion.utils.OkHttp;
import com.wangxiaolu.promotion.utils.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-03-29 17
 * @describe :
 */
@Slf4j
@Service
public class QinCeDataTaskServiceImpl implements QinCeDataTaskService {

    @Autowired
    QinCeDepartmentDao qinCeDepartmentDao;
    @Autowired
    QinCeEmployeeDao qinCeEmployeeDao;
    @Autowired
    QinCeUtils qinCeUtils;

    @Override
    public void departmentSyncTask() {
        // 查询组织架构参数、创建url
        Map<String, Object> params = qinCeUtils.queryOrgParam();
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_ORGANIZATION,params);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.post(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");

        if (responseDatas.size() <= 0) {
            log.error("勤策-同步组织架构/部门数据，未查询到数据");
            return;
        }
        qinCeDepartmentDao.departmentSyncTask(responseDatas);

    }

    @Override
    public void employeeSyncTask() {
        // 查询组织架构参数、创建url
        Map<String, Object> params = qinCeUtils.queryEmployeeParam(false);
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_EMPLOYEE,params);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.post(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");

        if (responseDatas.size() <= 0) {
            log.error("勤策-同步人员数据，未查询到数据");
            return;
        }
        qinCeEmployeeDao.employeeSyncTask(responseDatas);

    }
}
