package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.domain.user.dao.UserInfoDao;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.vo.UserLoginParam;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.user.PromotionService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-03-28 18
 * @describe : user模块-promotion逻辑
 */
@Slf4j
@Service
public class PromotionServiceImpl implements PromotionService {

    @Autowired
    UserInfoDao userInfoDao;

    /**
     * Promotion登录验证
     */
    @Override
    public void login(UserLoginParam userLoginParam) {
        Integer userCount = userInfoDao.findUserByUserName(userLoginParam.getLoginName());
        if (1 == userCount){
            // 生成登录信息
            log.info("生成登录信息：{}",userLoginParam.getLoginName());
            return;
        }
        throw new ParamException(RCode.LOGIN_PARAM_ERROR,null);
    }
}
