package com.wangxiaolu.promotion.domain.user.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-03-29 15
 * @describe : 勤策-组织架构-dto
 */
@TableName(value ="qince_department")
@Data
public class QinCeDepartmentDO {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 勤策的部门唯一ID。如果id和org_id同时存在则优先顺序为id、org_id
     */
    @JsonProperty("id")
    private String qcId;

    /**
     * 来源于第三方系统的部门唯一ID，对应新增部门 (org_id)字段，只有当数据来源于新增接口时才有值，如果数据从勤策系统中直接创建则该字段值为空。
     * 如果id和org_id同时存在则优先顺序为id、org_id
     */
    @JsonProperty("org_id")
    private String orgId;


    /**
     * 部门编码，必须唯一
     */
    @JsonProperty("org_code")
    private String orgCode;

    /**
     * 部门名称。同一部门下的子部门的名称不能重复
     */
    @JsonProperty("org_name")
    private String orgName;

    /**
     * 勤策上级部门唯一ID
     */
    @JsonProperty("waiqin365_parent_id")
    private String waiqin365ParentId;

    /**
     * 第三方系统上级部门唯一ID
     */
    @JsonProperty("org_parent_id")
    private String orgParentId;

    /**
     * 上级部门编码
     */
    @JsonProperty("parent_code")
    private String parentCode;

    /**
     * 上级部门名称
     */
    @JsonProperty("parent_name")
    private String parentName;

    /**
     * 勤策部门ID全路径
     */
    @JsonProperty("full_ids")
    private String fullIds;

    /**
     * 部门编码全路径
     */
    @JsonProperty("full_codes")
    private String fullCodes;

    /**
     * 部门名称全路径
     */
    @JsonProperty("full_names")
    private String fullNames;

    /**
     * 排序号，顺序排列
     */
    @JsonProperty("org_sequence")
    private BigDecimal orgSequence;

    /**
     * 部门状态。0：删除，1：正常
     */
    @JsonProperty("org_status")
    private Integer orgStatus;

    /**
     * 创建时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("create_time")
    private Date createTime;

    /**
     * 修改时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("modify_time")
    private Date modifyTime;

}
