package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.domain.user.mapper.TemporaryInfoMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.TemporaryInfoDO;
import com.wangxiaolu.promotion.domain.user.wrapper.TemporaryWrapper;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-04-08 16
 * @describe :促销员-信息
 */
@Service
public class TemporaryInfoDaoImpl implements TemporaryInfoDao {

    @Autowired
    TemporaryInfoMapper temporaryInfoMapper;

    /**
     * 微信-小程序注册的促销员信息
     */
    @Override
    public int saveWxTemporaryInfo(WxTemporaryInfoDto temporaryDto) {
        TemporaryInfoDO entity = new TemporaryInfoDO();
        BeanUtils.copyProperties(temporaryDto, entity);
        return temporaryInfoMapper.insert(entity);
    }

    @Override
    public Boolean existTemporaryByOpenId(String openId) {
        TemporaryWrapper tw = new TemporaryWrapper().setOpenId(openId);
        LambdaQueryWrapper qw = buildQueryList(tw);
        Integer count = temporaryInfoMapper.selectCount(qw);
        return count > 0;
    }

    private LambdaQueryWrapper buildQueryList(TemporaryWrapper tw){
        LambdaQueryWrapper<TemporaryInfoDO> queryWrapper = new LambdaQueryWrapper<>();
        if (!StringUtils.isEmpty(tw.getOpenId())){
            queryWrapper.eq(TemporaryInfoDO::getOpenId,tw.getOpenId());
        }
        return queryWrapper;
    }
}
