package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.user.dao.QinCeDepartmentDao;
import com.wangxiaolu.promotion.domain.user.mapper.QinceDepartmentMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.QinCeDepartmentDO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-03-29 17
 * @describe :勤策部门
 */
@Slf4j
@Service
public class QinCeDepartmentDaoImpl implements QinCeDepartmentDao {

    @Autowired
    QinceDepartmentMapper qinceDepartmentMapper;

    @Override
    public void departmentSyncTask(JSONArray responseDatas) {
        log.info("勤策-同步组织架构/部门数据，共「{}」条数据", responseDatas.size());
        LambdaQueryWrapper<QinCeDepartmentDO> qw = new LambdaQueryWrapper<>();

        for (Object responseData : responseDatas) {
            qw.clear();

            // 查询当前部门是否存在
            QinCeDepartmentDO qcDo = JSONObject.parseObject(JSONObject.toJSONString(responseData), QinCeDepartmentDO.class);
            qw.eq(QinCeDepartmentDO::getQcId, qcDo.getQcId());
            QinCeDepartmentDO doExist = qinceDepartmentMapper.selectOne(qw);

            // 存在则修改，不存在则添加
            if (Objects.isNull(doExist)) {
                qinceDepartmentMapper.insert(qcDo);
                log.info("勤策-{}部门数据未存在，已添加，路径为：{}", qcDo.getOrgName(), qcDo.getFullNames());
            } else {
                qcDo.setId(doExist.getId());
                qinceDepartmentMapper.updateById(qcDo);
                log.info("勤策-{}部门数据已存在，现已修改，路径为：{}", qcDo.getOrgName(), qcDo.getFullNames());
            }

        }

    }


}
