package com.wangxiaolu.promotion.controller.wechat;

import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import com.wangxiaolu.promotion.utils.WxMaUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-04-09 13
 * @describe :微信用户信息查询
 */
@Slf4j
@RestController
@RequestMapping("/user/wechat/query")
public class WeChatUserQueryController {
    @Autowired
    private WxMaUtils wxMaUtils;

    @Autowired
    private WeChatUserQueryService weChatUserQueryService;

    /**
     * 接收wx临时登录凭证code，查询openid是否已注册
     * 促销员查询
     */
    @GetMapping("/temporary/openid")
    public Boolean getOpenIdByWxcode(String jsCode) {
        if (StringUtils.isEmpty(jsCode)){
            return null;
        }
        String userOpenId = wxMaUtils.getWxOpenId(jsCode);
//        String userOpenId = "openid111";
        return weChatUserQueryService.queryTemporaryByOpenId(userOpenId);
    }


}
