package com.wangxiaolu.promotion.domain.user.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * 
 * @TableName qince_product_info
 */
@TableName(value ="qince_product_info")
@Data
public class QinceProductInfoDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 商品唯一标识，来源第三方系统的唯一ID（ERP）
     */
    @JsonProperty("prd_id")
    private String prdId;

    /**
     * 勤策商品id
     */
    @JsonProperty("prd_waiqin365_id")
    private String prdWaiqin365Id;

    /**
     * 商品名称
     */
    @JsonProperty("prd_name")
    private String prdName;

    /**
     * 商品类型唯一ID，所属类型
     */
    @JsonProperty("class_id")
    private String classId;

    /**
     * 商品类型名称
     */
    @JsonProperty("class_name")
    private String className;

    /**
     * 商品类型全路径
     */
    @JsonProperty("class_full_path")
    private String classFullPath;

    /**
     * 单位
     */
    @JsonProperty("prd_unit")
    private String prdUnit;

    /**
     * 商品规格
     */
    @JsonProperty("prd_spec")
    private String prdSpec;

    /**
     * 商品分类，0：普通商品，1：助销物料，2：包装物，3：兑换物料
     */
    @JsonProperty("classification")
    private String classification;

    /**
     * 商品编码
     */
    @JsonProperty("prd_code")
    private String prdCode;

    /**
     * 销售状态。0：停售，1：在售
     */
    @JsonProperty("prd_sale_status")
    private String prdSaleStatus;

    /**
     * 销售状态。0：停售，1：在售
     */
    @JsonProperty("sale_status")
    private String saleStatus;

    /**
     * 删除标志。1：正常，0：删除
     */
    @JsonProperty("status")
    private String status;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}