package com.wangxiaolu.promotion.service.user.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleStoreDao;
import com.wangxiaolu.promotion.domain.user.dao.QinCeDepartmentDao;
import com.wangxiaolu.promotion.domain.user.dao.QinCeEmployeeDao;
import com.wangxiaolu.promotion.service.user.QinCeDataTaskService;
import com.wangxiaolu.promotion.utils.OkHttp;
import com.wangxiaolu.promotion.utils.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-03-29 17
 * @describe :
 */
@Slf4j
@Service
public class QinCeDataTaskServiceImpl implements QinCeDataTaskService {

    @Autowired
    QinCeUtils qinCeUtils;
    @Autowired
    QinCeDepartmentDao qinCeDepartmentDao;
    @Autowired
    QinCeEmployeeDao qinCeEmployeeDao;
    @Autowired
    QinCeClienteleStoreDao qinCeClienteleShopDao;

    @Override
    public void departmentSyncTask() {
        // 查询组织架构参数、创建url
        Map<String, Object> params = qinCeUtils.queryOrgParam();
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_ORGANIZATION, params);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");

        if (responseDatas.size() <= 0) {
            log.error("勤策-同步组织架构/部门数据，未查询到数据");
            return;
        }
        qinCeDepartmentDao.departmentSyncTask(responseDatas);

    }

    @Override
    public void employeeSyncTask() {
        // 查询组织架构参数、创建url
        Map<String, Object> params = qinCeUtils.queryEmployeeParam(false);
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_EMPLOYEE, params);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");

        if (responseDatas.size() <= 0) {
            log.error("勤策-同步人员数据，未查询到数据");
            return;
        }
        qinCeEmployeeDao.employeeSyncTask(responseDatas);

    }

    /**
     * 同步[终端数据]
     */
    @Override
    public void shopDetailAllTask() {
        int i = 0;
        boolean nextPage = true;
        while (nextPage) {
            i++;
            nextPage = booleanshopDetailPage(i);
        }
    }

    private boolean booleanshopDetailPage(Integer pageNum) {
        Map<String, Object> params = qinCeUtils.queryShopParam(pageNum);
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_SHORE, params);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");
        if (responseDatas.size() <= 0) {
            log.error("勤策-同步终端store数据，未查询到数据");
            return false;
        }

        log.info("勤策-同步终端store数据，查询到第{}页数据「{}」条", pageNum, responseDatas.size());
        qinCeClienteleShopDao.shopDetailAllTask(responseDatas);
        return true;
    }
}
