package com.wangxiaolu.promotion.controller.user.employee;

import com.wangxiaolu.promotion.pojo.user.vo.LoginVo;
import com.wangxiaolu.promotion.pojo.user.vo.UserLoginParam;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.user.WangxlEmployeeQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-05-28 19
 * @describe : 王小卤员工登录接口
 */
@RestController
@RequestMapping("/user/employee")
public class WangxlEmployeeLoginController {

    @Autowired
    WangxlEmployeeQueryService wangxlEmployeeQueryService;

    @PostMapping("/login")
    public R wangxlEmployeelogin(@RequestBody UserLoginParam userLoginParam) {
        userLoginParam.validate();
        LoginVo loginVo = wangxlEmployeeQueryService.employeeLoginVerify(userLoginParam);
        return R.success(loginVo);
    }

}
